 

# URL 跳转配置

URL 跳转配置是指在 H5 页面中可以通过调用接口跳转到应用。

## 接入方式


使用本功能，需要在网页中嵌入以下 js，支持 HTTP 与 HTTPS 访问。


``` js
<script type="text/javascript" src="//statres.quickapp.cn/quickapp/js/routerinline.min.js"></script>
```

## 调起应用

appRouter(packageName, path, params, confirm)


| 参数名 |  类型 | <div style="width: 50px">必填</div>|  说明 |
| --- |  --- |  --- |  --- |
| packageName |  String    |  是 |  应用的包名，和 manifest.json 中保持一致。 |
| path |  String    |  否 |  跳转的页面路径，对应于 manifest.json 中 page 的 path 字段。 |
| params |  Object    |  否 |  传递的参数。 |
| confirm |  String    |  否 |  在跳转确认弹窗中显示的名称，当不传或者为 false 时，表示无需用户确认直接跳转；当为其他非空值时，表示跳转时需要用户确认。 |

示例：

```
<!DOCTYPE html>
<html>
  <head>
    <title>URL跳转配置</title>
    <script
      type="text/javascript"
      src="//statres.quickapp.cn/quickapp/js/routerinline.min.js"
    ></script>
  </head>
  <body>
    <!-- 调起应用 -->
    <script type="text/javascript">
      // 无需用户确认的调用方式，xxx.yyy.zzz为包名
      appRouter('xxx.yyy.zzz', '/Home', { a: 1, b: 'abc' })
      // 需要用户确认的调用方式，xxx.yyy.zzz为包名
      appRouter(
        'xxx.yyy.zzz',
        '/Home',
        { a: 1, b: 'abc' },
        '显示给用户的应用名称'
      )
    </script>
  </body>
</html>
```

### 检测平台是否支持服务

channelReady(callback)

| 参数名 |  类型 | <div style="width: 50px">必填</div>|  说明 |
| --- |  --- |  --- |  --- |
| callback |  function    |  是 |  应用的包名，和 manifest.json 中保持一致。 |
| path |  String    |  否 |  检测的回调函数，无论检测到是否支持服务，都会执行回调函数。平台支持服务则传入实参 true，否则传入实参 false。 |


示例:

```
<!DOCTYPE html>
<html>
  <head>
    <title>URL跳转配置</title>
    <script
      type="text/javascript"
      src="//statres.quickapp.cn/quickapp/js/routerinline.min.js"
    ></script>
  </head>
  <body>
    <!-- 检测平台是否支持服务 -->
    <script type="text/javascript">
      // 通过传递回调函数实现
      channelReady(function(bAvailable) {
        alert('是否存在框架服务：' + bAvailable)
      })
    </script>
  </body>
</html>
```
