# [SelectorQuery](SelectorQuery.html) SelectorQuery.in(Component component)

将选择器的选取范围更改为自定义组件 `component` 内。（初始时，选择器仅选取页面范围的节点，不会选取任何自定义组件中的节点）。

## 参数

### Component component

自定义组件实例

## 返回值

### [SelectorQuery](SelectorQuery.html)

## 示例代码

```js
Component({
  queryMultipleNodes() {
    const query = qa.createSelectorQuery().in(this)
    query
      .select('#the-id')
      .boundingClientRect(function(res) {
        res.top // 这个组件内 #the-id 节点的上边界坐标
      })
      .exec()
  }
})
```
