# 数据绑定

QXML 中的数据来源于逻辑层。

## 简单绑定

数据绑定使用双大括号将变量包起来，可以作用于：

### 内容

```html
<view> {{ msg }} </view>
```

```js
Page({
  data: {
    msg: 'Hello QuickApp!'
  }
})
```

### 组件属性(需要在双引号之内)

```html
<view id="item-{{id}}"> </view>
```

```js
Page({
  data: {
    id: '1'
  }
})
```

### 控制属性(需要在双引号之内)

```html
<view qa:if="{{flag}}"> </view>
```

```js
Page({
  data: {
    flag: true
  }
})
```

### 关键字(需要在双引号之内)

`true`：boolean 类型的 true，真值。

`false`： boolean 类型的 false，假值。

```html
<checkbox checked="{{false}}"> </checkbox>
```

## 运算

可以在 `{{}}` 内进行运算，支持的有如下几种方式：

### 三元运算

```html
<view hidden="{{flag ? true : false}}"> Hidden </view>
```

### 算数运算

```html
<view> {{a + b}} + {{c}} + d </view>
```

```js
Page({
  data: {
    a: 1,
    b: 2,
    c: 3
  }
})
```

view 中的内容为 `3 + 3 + d`。

### 逻辑判断

```html
<view qa:if="{{length > 5}}"> </view>
```

### 字符串运算

```html
<view>{{"hello" + name}}</view>
```

```js
Page({
  data: {
    name: 'QuickApp'
  }
})
```

### 数据路径运算

```html
<view>{{object.key}} {{array[0]}}</view>
```

```js
Page({
  data: {
    object: {
      key: 'Hello '
    },
    array: ['QuickApp']
  }
})
```

## 组合

也可以在双大括号内直接进行组合，构成新的对象或者数组。

### 数组

```html
<view qa:for="{{[zero, 1, 2, 3]}}"> {{item}} </view>
```

```js
Page({
  data: {
    zero: 0
  }
})
```

最终组合成数组`[0, 1, 2, 3]`。

### 对象

**注意双大括号内还需要一层大括号**

```html
<template is="customComp" data="{{ {for: a, bar: b} }}"></template>
```

```js
Page({
  data: {
    a: 1,
    b: 2
  }
})
```

最终组合成的对象是 `{for: 1, bar: 2}`

也可以用扩展运算符 `...` 来将一个对象展开

```html
<template is="customComp" data="{{ {...obj1, ...obj2, e: 5} }}"></template>
```

```js
Page({
  data: {
    obj1: {
      a: 1,
      b: 2
    },
    obj2: {
      c: 3,
      d: 4
    }
  }
})
```

最终组合成的对象是 `{a: 1, b: 2, c: 3, d: 4, e: 5}`。

如果对象的 key 和 value 相同，也可以间接地表达。

```html
<template is="customComp" data="{{ {foo, bar} }}"></template>
```

```js
Page({
  data: {
    foo: 'foo-value',
    bar: 'bar-value'
  }
})
```

最终组合成的对象是 `{foo: 'foo-value', bar:'bar-value'}`。

**注意**：上述方式可以随意组合，但是如有存在变量名相同的情况，后边的会覆盖前面，如：

```html
<template is="customComp" data="{{ {...obj1, ...obj2, a, c: 6} }}"></template>
```

```js
Page({
  data: {
    obj1: {
      a: 1,
      b: 2
    },
    obj2: {
      b: 3,
      c: 4
    },
    a: 5
  }
})
```

最终组合成的对象是 `{a: 5, b: 3, c: 6}`。

**注意：** 花括号和引号之间的空格会被自动忽略：如 `qa:for=" {{[1,2,3]}} "` 等同于 `qa:for="{{[1,2,3]}}"`
