# Component 构造器

开发者可以调用 `Component` 指定自定义组件的属性、数据、方法等。

```js
Component({
  behaviors: [],

  properties: {
    propName: {
      // 属性名
      type: String,
      value: ''
    },
    propName2: String // 简化的定义方式
  },

  data: {}, // 组件内数据，可用于模板渲染

  lifetimes: {
    // 生命周期函数
    attached: function() {},
    detached: function() {},
    ready: function() {}
  },

  pageLifetimes: {
    // 所在页面的生命周期函数
    show: function() {},
    hide: function() {},
    resize: function() {}
  },

  methods: {
    handleTap: function() {
      this.setData({
        // 更新属性和数据的方法与更新页面数据的方法一致
      })
    }
  }
})
```

详情[Component 参考文档](../../reference/api/Component.html)

## 使用 Component 构造页面

快应用的页面也可以视为自定义组件。因而，页面也可以使用 `Component` 构造器构造，拥有与普通组件一样的定义段与实例方法。注意，需要设置 `"component": true`。

此时，组件的属性可以用于接收页面的参数，如访问页面 `/pages/detail/detail?paramA=1&paramB=a` ，如果声明有属性 `paramA` 或 `paramB` ，则它们会被赋值为 `1` 或 `a` 。

页面的生命周期方法（即 `on` 开头的方法），应写在 `methods` 定义段中。

**代码示例：**

```json
{
  "usingComponents": {}
}
```

```js
Component({
  properties: {
    paramA: Number,
    paramB: String
  },

  methods: {
    onLoad: function() {
      this.data.paramA // 页面参数 paramA 的值
      this.data.paramB // 页面参数 paramB 的值
    }
  }
})
```
