# 注册页面

快应用中注册一个页面，可以使用 `Page` 方法，也可以使用 `Component` 方法。

## 使用 Page 注册页面

在页面 js 中调用 `Page()` 注册页面

```js
//index.js
Page({
  data: {
    text: 'Hello QuickApp'
  },
  onLoad: function(options) {
    // 页面创建时执行
  },
  onShow: function() {
    // 页面显示时执行
  },
  onReady: function() {
    // 页面首次渲染完成时执行
  },
  onHide: function() {
    // 页面隐藏时执行
  },
  onUnload: function() {
    // 页面销毁时执行
  },
  onPullDownRefresh: function() {
    // 下拉刷新时执行
  },
  onReachBottom: function() {
    // 页面到达底部时执行
  },
  onPageScroll: function() {
    // 页面滚动时执行
  },
  onResize: function() {
    // 视窗尺寸变化时执行
  },
  onTabItemTap(item) {
    // tabBar 点击切换时执行
  },
  // 事件回调
  handleTap: function() {
    this.setData(
      {
        text: 'new text'
      },
      function() {
        // setData 更新完界面后触发
      }
    )
  },
  // 其他自定义数据
  extraData: {
    hi: 'QuickApp'
  }
})
```

详细的参数含义和使用请参考 [Page 参考文档](../../reference/api/Page.html) 。

## 使用 Component 注册页面

利用 `Component` 定义一个页面，可以使用 `Component` 的更多特性，如 `behaviors` 等。

需要注意，自定义方法和页面生命周期需要定义在 `methods` 属性中。

```js
Component({
  data: {
    text: 'page data'
  },
  methods: {
    onLoad: function(options) {
      // 页面创建时执行
    },
    onPullDownRefresh: function() {
      // 下拉刷新时执行
    },
    // 事件响应函数
    handleTap: function() {
      // ...
    }
  }
})
```

具体细节请阅读 [`Component`](./../custom-component/component.html) 章节。
