# view

视图容器

| 属性 | 类型 | <div style="width: 50px">默认值 </div> | <div style="width: 50px">必填 </div> | 说明 |
| --- | --- | --- | --- | --- |
| hover-class | string | none | 否 | 指定 hover 时的样式类。当 `hover-class="none"` 时，没有点击态效果 |
| hover-stop-propagation | boolean | false | 否 | 指定是否阻止本节点的祖先节点出现 hover 态 |
| hover-start-time | number | 50 | 否 | 按住后多久出现 hover 状态，单位毫秒 |
| hover-stay-time | number | 400 | 否 | 手指松开后点 hover 状态保留时间，单位毫秒 |

## Bug & Tip

::: warning

- 如果需要使用滚动视图，请使用 [scroll-view](scroll-view.html)

:::

## 示例代码

```html
<view class="section">
  <view class="section__title">flex-direction: row</view>
  <view class="flex-wrp" style="flex-direction:row;">
    <view class="flex-item bc_green">1</view>
    <view class="flex-item bc_red">2</view>
    <view class="flex-item bc_blue">3</view>
  </view>
</view>
<view class="section">
  <view class="section__title">flex-direction: column</view>
  <view class="flex-wrp" style="height: 300px;flex-direction:column;">
    <view class="flex-item bc_green">1</view>
    <view class="flex-item bc_red">2</view>
    <view class="flex-item bc_blue">3</view>
  </view>
</view>
```
