# movable-view

在页面中可以通过拖拽滑动的可移动的视图容器。[movable-view](movable-view.html)必须在 [movable-area](movable-area.html) 组件中，并且必须是直接子节点，否则不能移动。

| 属性 | 类型 | <div style="width: 50px">默认值 </div> | <div style="width: 50px">必填 </div> | 说明 |
| --- | --- | --- | --- | --- |
| direction | string | none | 否 | movable-view 的移动方向，属性值有 all、vertical、horizontal、none |
| inertia | boolean | false | 否 | movable-view 是否带有惯性 |
| out-of-bounds | boolean | false | 否 | 超过可移动区域后，movable-view 是否还可以移动 |
| x | number |  | 否 | 定义 x 轴方向的偏移，如果 x 的值不在可移动范围内，会自动移动到可移动范围；改变 x 的值会触发动画 |
| y | number |  | 否 | 定义 y 轴方向的偏移，如果 y 的值不在可移动范围内，会自动移动到可移动范围；改变 y 的值会触发动画 |
| damping | number | 20 | 否 | 阻尼系数，用于控制 x 或 y 改变时的动画和过界回弹的动画，值越大移动越快 |
| friction | number | 2 | 否 | 摩擦系数，用于控制惯性滑动的动画，值越大摩擦力越大，滑动越快停止；必须大于 0，否则会被设置成默认值 |
| disabled | boolean | false | 否 | 是否禁用 |
| scale | boolean | false | 否 | 是否支持双指缩放，默认缩放手势生效区域是在 movable-view 内 |
| scale-min | number | 0.5 | 否 | 定义缩放倍数最小值 |
| scale-max | number | 10 | 否 | 定义缩放倍数最大值 |
| scale-value | number | 1 | 否 | 定义缩放倍数，取值范围为 0.5 - 10 |
| animation | boolean | true | 否 | 是否使用动画 |  |
| bindchange | eventhandle |  | 否 | 拖动过程中触发的事件，event.detail = {x, y, source} |
| bindscale | eventhandle |  | 否 | 缩放过程中触发的事件，event.detail = {x, y, scale} |
| htouchmove | eventhandle |  | 否 | 初次手指触摸后移动为横向的移动时触发，如果 catch 此事件，则意味着 touchmove 事件也被 catch |
| vtouchmove | eventhandle |  | 否 | 初次手指触摸后移动为纵向的移动时触发，如果 catch 此事件，则意味着 touchmove 事件也被 catch |

## `bindchange` 返回的 `source` 表示产生移动的原因

| 值                  | 说明                 |
| ------------------- | -------------------- |
| touch               | 拖动                 |
| touch-out-of-bounds | 超出移动范围         |
| out-of-bounds       | 超出移动范围后的回弹 |
| friction            | 惯性                 |
| 空字符串            | setData              |

## Bug & Tip

::: warning

- movable-view 必须设置 width 和 height 属性，不设置默认为 10px
- movable-view 默认为绝对定位，top 和 left 属性为 0px

:::
