# RecorderManager.start(Object object)

开始录音

## 参数

### Object object

| 属性 | 类型 | <div style="width: 50px">默认值</div> | <div style="width: 50px">必填</div> | 说明 |
| --- | --- | --- | --- | --- |
| duration | number | 60000 | 否 | 录音的时长，单位毫秒，最大值 600000（10 分钟） |  |
| sampleRate | number | 8000 | 否 | 录音的采样率。不同的音频格式所支持的采样率范围不同。对于 aac 格式，默认设置为 8000，建议使用 8000/16000/44100 |  |
| numberOfChannels | number | 2 | 否 | 录音的通道数 |  |
| encodeBitRate | number | 48000 | 否 | 录音的编码码率，有效值见下表格 |  |
| format | string | aac | 否 | 音频格式 |  |

**object.sampleRate 的合法值**

| 值    | 说明         |
| ----- | ------------ |
| 8000  | 8000 采样率  |  |
| 16000 | 16000 采样率 |  |
| 44100 | 44100 采样率 |  |

**object.numberOfChannels 的合法值**

| 值  | 说明     |
| --- | -------- |
| 1   | 1 个通道 |  |
| 2   | 2 个通道 |  |

**object.format 的合法值**

| 值  | 说明     |
| --- | -------- |
| mp3 | mp3 格式 |  |
| aac | aac 格式 |  |

## 采样率与编码码率限制

每种采样率有对应的编码码率范围有效值，设置不合法的采样率或编码码率会导致录音失败，具体对应关系如下表。

| 采样率 | 编码码率       |
| ------ | -------------- |
| 8000   | 16000 ~ 48000  |
| 16000  | 24000 ~ 96000  |
| 44100  | 64000 ~ 320000 |
