### Page(Object object)

注册快应用中页面。`Object` 参数中可以指定页面的初始数据、生命周期回调、事件处理函数等。

#### 参数

##### Object object

| 属性 | 类型 | <div style="width: 50px">默认值</div> | <div style="width: 50px">必填</div> | 说明 |
| --- | --- | --- | --- | --- |
| [data](#data) | Object |  |  | 页面的初始数据 |
| [onLoad](#onload-object-query) | function |  |  | 生命周期回调—监听页面加载 |
| [onShow](#onshow) | function |  |  | 生命周期回调—监听页面显示 |
| [onReady](#onready) | function |  |  | 生命周期回调—监听页面初次渲染完成 |
| [onHide](#onhide) | function |  |  | 生命周期回调—监听页面隐藏 |
| [onUnload](#onunload) | function |  |  | 生命周期回调—监听页面卸载 |
| [onPullDownRefresh](#onpulldownrefresh) | function |  |  | 监听用户下拉动作 |
| [onReachBottom](#onreachbottom) | function |  |  | 页面上拉触底事件的处理函数 |
| [onPageScroll](#onpagescroll-object-object) | function |  |  | 页面滚动触发事件的处理函数 |
| [onResize](#onresize-object-object) | function |  |  | 页面尺寸改变时触发，详见 [响应显示区域变化](../../framework/view/resizable.html#%E5%9C%A8%E6%89%8B%E6%9C%BA%E4%B8%8A%E5%90%AF%E7%94%A8%E5%B1%8F%E5%B9%95%E6%97%8B%E8%BD%AC%E6%94%AF%E6%8C%81) |
| [onTabItemTap](#ontabitemtap-object-object) | function |  |  | 当前是 tab 页时，点击 tab 时触发 |
| 其他 | any |  |  | 开发者可以添加任意的函数或数据到 `Object` 参数中，在页面的函数中用 `this` 可以访问 |

#### 示例代码

```js
//index.js
Page({
  data: {
    text: 'Hello QuickApp'
  },
  onLoad: function(options) {
    // 页面创建时执行
  },
  onShow: function() {
    // 页面显示时执行
  },
  onReady: function() {
    // 页面首次渲染完成时执行
  },
  onHide: function() {
    // 页面隐藏时执行
  },
  onUnload: function() {
    // 页面销毁时执行
  },
  onPullDownRefresh: function() {
    // 下拉刷新时执行
  },
  onReachBottom: function() {
    // 页面到达底部时执行
  },
  onPageScroll: function() {
    // 页面滚动时执行
  },
  onResize: function() {
    // 视窗尺寸变化时执行
  },
  onTabItemTap(item) {
    // tabBar 点击切换时执行
  },
  // 事件回调
  handleTap: function() {
    this.setData(
      {
        text: 'new text'
      },
      function() {
        // setData 更新完界面后触发
      }
    )
  },
  // 其他自定义数据
  extraData: {
    hi: 'QuickApp'
  }
})
```

#### data

`data` 定义页面的初始数据。

页面加载时，`data` 对象会被字符串化，发送至渲染层，因此`data`中的数据必须是 `JSON` 支持的数据类型：字符串，数字，布尔值，对象，数组，null。

渲染层可以通过 [QXML](./../../reference/qxml) 对数据进行绑定。

**示例代码：**

```html
<view>{{msg}}</view>
```

```js
Page({
  data: {
    msg: 'init data'
  }
})
```

### 生命周期回调函数

生命周期的触发受页面路由方式的影响可以参考[文档](../../framework/app-service/route.html)

#### onLoad(Object query)

页面加载时触发,只会触发一次。入参是打开当前页面路径中的参数。

**参数：**

| 名称  | 类型   | 说明                     |
| ----- | ------ | ------------------------ |
| query | Object | 打开当前页面路径中的参数 |

#### onShow()

页面第一次打开或者切换到前台时触发。

#### onReady()

页面第一次渲染完成时触发，只触发一次。表示页面 dom 已经渲染完毕，可以和渲染层进行交互。

::: warning 注意：依赖于界面渲染完成的 API 如 qa.createSelectorQuery、 qa.createVideoContext 等，请在`onReady`之后调用

:::

#### onHide()

页面隐藏时触发。 如调用 [qa.navigateTo](../../api/route/qa.navigateTo.html) 或底部 `tab` 切换到其他页面或快应用切入后台等时机会触发。

#### onUnload()

页面卸载时触发。如[qa.redirectTo](../../api/route/qa.redirectTo.html)或[qa.navigateBack](../../api/route/qa.navigateBack.html)到其他页面时。

### 页面事件处理函数

#### onPullDownRefresh()

监听用户下拉刷新事件。

- 需要在`app.json`的[`window`](../configuration/app.html#window)选项中或[页面配置](../configuration/page.html)中设置 `"enablePullDownRefresh": true`。
- [qa.startPullDownRefresh](../../api/ui/pull-down-refresh/qa.startPullDownRefresh.html)接口也可以触发下拉刷新，效果与用户手动下拉刷新一致。
- [qa.stopPullDownRefresh](../../api/ui/pull-down-refresh/qa.stopPullDownRefresh.html)接口可以停止当前页面的下拉刷新。

#### onReachBottom()

监听用户上拉触底事件。

- 可以在`app.json`的[`window`](../configuration/app.html#window)选项中或[页面配置](../configuration/page.html)中设置触发距离`onReachBottomDistance`。
- 在触发距离内滑动期间，本事件只会被触发一次。

#### onPageScroll(Object object)

监听用户滚动页面事件。

**参数 Object object**:

| 属性      | 类型   | 说明                                  |
| --------- | ------ | ------------------------------------- |
| scrollTop | Number | 页面在垂直方向已滚动的距离（单位 px） |

**注意：请只在需要的时候才在 page 中定义此方法，并尽量减少 onPageScroll 中的 setData 操作，以免影响逻辑层和渲染层的通信耗时**

#### onResize(Object object)

显示区域发生变化时触发。详见 [响应显示区域变化](../../framework/view/resizable.html#%E5%9C%A8%E6%89%8B%E6%9C%BA%E4%B8%8A%E5%90%AF%E7%94%A8%E5%B1%8F%E5%B9%95%E6%97%8B%E8%BD%AC%E6%94%AF%E6%8C%81)

#### onTabItemTap(Object object)

点击切换 tab 时触发

**Object 参数说明：**

| 参数     | 类型   | 说明                             |
| -------- | ------ | -------------------------------- |
| index    | String | 被点击 tabItem 的序号，从 0 开始 |  |
| pagePath | String | 被点击 tabItem 的页面路径        |  |
| text     | String | 被点击 tabItem 的按钮文字        |  |

**示例代码：**

```js
Page({
  onTabItemTap(item) {
    console.log(item.index, item.pagePath, item.text)
  }
})
```

### 事件处理函数

`Page` 中可以定义事件处理函数。在渲染层的组件中加入[事件绑定](../../framework/view/event.html)，当事件被触发时，就会执行 Page 中定义的事件处理函数。

**示例代码：**

```html
<view bindtap="handleTap"> click view </view>
```

```js
Page({
  handleTap: function() {
    console.log('view tap')
  }
})
```

### Page.route

到当前页面的路径，类型为`String`。

```js
Page({
  onShow: function() {
    console.log(this.route)
  }
})
```

### Page.prototype.setData(Object data, Function callback)

`setData` 函数会同步修改当前页面的 `data` 值，并将数据从逻辑层发送到渲染层触发页面更新（异步）。

#### 参数说明

| 字段     | 类型     | <div style="width: 50px">必填</div> | 描述                                       | 最低版本 |
| -------- | -------- | ----------------------------------- | ------------------------------------------ | -------- |
| data     | Object   | 是                                  | 这次要改变的数据                           |          |
| callback | Function | 否                                  | setData 引起的界面更新渲染完毕后的回调函数 |          |

`Object` 以 `key: value` 的形式表示，将 `data` 中的 `key` 对应的值改变成 `value`。

**其中 `key` 支持以数据路径的形式给出，支持改变数组中的某一项或对象的某个属性，如 `array[2].message`，`a.b.c.d`。**

**注意：**

1. **直接修改 this.data 而不调用 this.setData 无法改变页面的显示，还会造成渲染层和逻辑层的数据不一致**。
2. 仅支持设置可 JSON 化的数据。
3. 尽量避免一次设置过多的数据。

**示例代码：**

```html
<!--index.qxml-->
<view>{{text}}</view>
<button bindtap="changeText">changeText</button>
<view>{{num}}</view>
<button bindtap="changeNum">changeNum</button>
<view>{{array[0].text}}</view>
<button bindtap="changeItemInArray">changeItemInArray</button>
<view>{{object.text}}</view>
<button bindtap="changeItemInObject">changeItemInObject</button>
```

```js
// index.js
Page({
  data: {
    text: 'init data',
    num: 0,
    array: [{ text: 'init data' }],
    object: {
      text: 'init data'
    }
  },
  changeText: function() {
    this.setData({
      text: 'changed data'
    })
  },
  changeNum: function() {
    // 也可以修改 this.data 之后马上用 setData 设置一下修改了的字段
    this.data.num = 1
    this.setData({
      num: this.data.num
    })
  },
  changeItemInArray: function() {
    // 对于对象或数组字段，可以直接修改一个其下的子字段，这样做通常比修改整个对象或数组更好
    this.setData({
      'array[0].text': 'changed data'
    })
  },
  changeItemInObject: function() {
    this.setData({
      'object.text': 'changed data'
    })
  }
})
```
