## Behavior(Object object)

注册 `behavior`。

### 参数

#### Object object

| 定义段     | 类型         | <div style="width: 50px">必填</div> | 描述                  |
| ---------- | ------------ | ----------------------------------- | --------------------- |
| properties | Object Map   | 否                                  | 同组件的属性          |  |
| data       | Object       | 否                                  | 同组件的数据          |  |
| methods    | Object       | 否                                  | 同自定义组件的方法    |  |
| behaviors  | String Array | 否                                  | 引入其它的 `behavior` |  |
| created    | Function     | 否                                  | 生命周期函数          |  |
| attached   | Function     | 否                                  | 生命周期函数          |  |
| ready      | Function     | 否                                  | 生命周期函数          |  |
| detached   | Function     | 否                                  | 生命周期函数          |  |

**代码示例：**

```js
// test-behavior.js
module.exports = Behavior({
  behaviors: [],
  properties: {
    testBehaviorProperty: {
      type: String
    }
  },
  data: {
    testBehaviorData: {}
  },
  attached: function() {},
  methods: {
    testBehaviorMethod: function() {}
  }
})
```
