# 组件模板和样式

创建自定义组件需要在 `qxml` 和 `css` 文件中编写模板和样式。

### 组件模板

语法和页面模板相同。组件模板与组件数据结合后生成的节点树，在引用位置上渲染。

在组件模板中可以使用 `<slot>` 插槽，用于传递子节点内容。

**代码示例：**

```html
<!-- 组件 qxml -->
<view class="custom">
  <view>这里是组件的内部节点</view>
  <slot></slot>
</view>
```

```html
<!-- 页面 qxml -->
<view>
  <custom>
    <!-- 这部分内容将被放置在组件 <slot> 的位置上 -->
    <view>这里是插入到组件slot中的内容</view>
  </custom>
</view>
```

注意，使用自定义组件需要先在 `json` 文件中定义 `usingComponents`，否则标签无效。

### 模板数据绑定

可以使用数据绑定,向子组件的属性传递动态数据。

**代码示例：**

```html
<!-- 页面 qxml -->
<view>
  <custom prop-a="{{dataA}}" prop-b="{{dataB}}">
    <!-- 这部分内容将被放置在组件 <slot> 的位置上 -->
    <view>这里是插入到组件slot中的内容</view>
  </custom>
</view>
```

在以上例子中，组件的属性 `propA` 和 `propB` 将收到页面传递的数据。页面可以通过 `setData` 来改变绑定的数据字段。

注意：这样的数据绑定只能传递 JSON 兼容数据。

### 组件 qxml 的 slot

在组件的 qxml 中可以使用 `slot` 插槽，用于传递子节点内容。

当定义多个 slot 时需要以不同的 `name` 来区分。

```html
<!-- 组件模板 -->
<view class="custom">
  <slot name="header"></slot>
  <view>这里是组件的内部细节</view>
  <slot name="footer"></slot>
</view>
```

使用时，用 `slot` 属性来将节点插入到不同的 slot 上。

```html
<!-- 引用组件的页面模板 -->
<view>
  <custom>
    <!-- 这部分内容将被放置在组件 <slot name="header"> 的位置上 -->
    <view slot="header">这里是插入到组件slot name="header"中的内容</view>
    <!-- 这部分内容将被放置在组件 <slot name="footer"> 的位置上 -->
    <view slot="footer">这里是插入到组件slot name="footer"中的内容</view>
  </custom>
</view>
```

### 组件样式

组件对应 `css` 文件的样式，只对组件 qxml 内的节点生效。编写组件样式时，需要注意以下几点：

- 继承样式，如 `font` 、 `color` ，会从组件外继承到组件内
- 自定义组件的样式类相互隔离，无法跨组件使用
- 组件内也可直接使用 `app.css` 和页面中定义的样式类
