# 递归组件

自定义组件只需要简单配置即可递归使用。

在自定义组件的 `.json` 配置文件中，添加 `name` 字段，并指定名称，则可以在自定义组件中使用此字段的值作为组件名。如:

_my-layer.json_

```json{2}
{
  "name": "my-layer",
  "component": true
}
```

_my-layer.js_

```js
Component({
  properties: {
    depth: {
      type: Number,
      value: 1
    }
  }
})
```

_my-layer.qxml_

```xml
<view class='my-layer'>
  this is layer {{ depth }}
  <my-layer qa:if='{{ depth > 1 }}' depth='{{ depth - 1 }}'></my-layer>
</view>
```

## 全局组件

`app.json` 中配置配置的组件，也可以作为递归组件使用。如：

_app.json_

```json
{
  "usingComponents": {
    "global-layer": "./components/global-layer/global-layer"
  }
}
```

_global-layer.js_

```js
Component({
  properties: {
    depth: {
      type: Number,
      value: 1
    }
  }
})
```

_global-layer.qxml_

```xml
<view class='global-layer'>
  this is layer {{ depth }}
  <global-layer qa:if='{{ depth > 1 }}' depth='{{ depth - 1 }}'></global-layer>
</view>
```

以上是两种组件的使用使用如：

_page.qxml_

```xml
<view>
  <my-layer depth='{{ 3 }}'></my-layer>
  <global-layer depth='{{ 3 }}'></global-layer>
</view>
```

::: warning 注意

使用递归组件时，需要注意使用条件控制递归，否则可能会出现无限循环，出现 “max stack size exceeded” 的错误。

:::
