# swiper

滑块视图容器。子组件只能是[swiper-item](swiper-item.html)组件，否则可能会发生未定义的行为。

| 属性 | 类型 | <div style="width: 50px">默认值 </div> | <div style="width: 50px">必填 </div> | 说明 |
| --- | --- | --- | --- | --- |
| indicator-dots | boolean | false | 否 | 是否显示面板指示点 |
| indicator-color | color | rgba(0, 0, 0, .3) | 否 | 指示点的颜色 |
| indicator-active-color | color | #000000 | 否 | 选中的指示点颜色 |
| autoplay | boolean | false | 否 | 是否自动轮转切换 |
| current | number | 0 | 否 | 当前所在滑块的 index |
| interval | number | 5000 | 否 | 自动切换时间间隔 |
| duration | number | 500 | 否 | 滑动动画时长 |
| circular | boolean | false | 否 | 是否采用循环滑动 |
| vertical | boolean | false | 否 | 滑动方向是否为纵向 |
| previous-margin | string | "0px" | 否 | 前边距，可用于露出前一项的一小部分，接受 px 和 rpx 值 |
| next-margin | string | "0px" | 否 | 后边距，可用于露出后一项的一小部分，接受 px 和 rpx 值 |
| display-multiple-items | number | 1 | 否 | 同时显示的滑块数量 |
| bindchange | eventhandle |  | 否 | current 改变时会触发 change 事件，event.detail = {current, source} |
| bindtransition | eventhandle |  | 否 | swiper-item 的位置发生改变时会触发 transition 事件，event.detail = {dx: dx, dy: dy} |
| bindanimationfinish | eventhandle |  | 否 | 动画结束时会触发 animationfinish 事件，event.detail = {dx: dx, dy: dy} |

## `change`事件 `source` 返回值

`change`事件含有 `source`字段，表示导致变更的原因，可能值如下：

::: tip

- `autoplay` 自动播放导致 swiper 变化；
- `touch` 用户划动引起 swiper 变化；
- 其它原因将用空字符串表示。

:::

## Bug & Tip

::: warning

- 如果在 `bindchange` 的事件回调函数中使用 `setData` 改变 `current` 值，则有可能导致 `setData` 被不停地调用，因而通常情况下请在改变 `current` 值前检测 `source` 字段来判断是否是由于用户触摸引起。

:::

## 示例代码

```html
<swiper indicator-dots="{{indicatorDots}}" autoplay="{{autoplay}}" interval="{{interval}}" duration="{{duration}}">
  <block qa:for="{{background}}" qa:key="*this">
    <swiper-item>
      <view class="swiper-item {{item}}"></view>
    </swiper-item>
  </block>
</swiper>

<view>指示点</view>
<switch checked="{{indicatorDots}}" bindchange="changeIndicatorDots" />
<view>自动播放</view>
<switch checked="{{autoplay}}" bindchange="changeAutoplay" />
```

```js
Page({
  data: {
    background: ['demo-text-1', 'demo-text-2', 'demo-text-3'],
    indicatorDots: true,
    vertical: false,
    autoplay: false,
    interval: 2000,
    duration: 500
  },

  changeIndicatorDots() {
    this.setData({
      indicatorDots: !this.data.indicatorDots
    })
  },

  changeAutoplay() {
    this.setData({
      autoplay: !this.data.autoplay
    })
  }
})
```

```css
.swiper-item {
  display: block;
  height: 150px;
}
```

![](~@assets/swiper.png)
