# progress

进度条。组件的默认属性长度单位为 px，支持传入单位(rpx/px)。

| 属性 | 类型 | <div style="width: 50px">默认值 </div> | <div style="width: 50px">必填 </div> | 说明 |
| --- | --- | --- | --- | --- |
| percent | number |  | 否 | 0~100 的百分比 |
| show-info | boolean | false | 否 | 在进度条右侧显示百分比 |
| border-radius | number/string | 0 | 否 | 圆角大小 |
| font-size | number/string | 16 | 否 | 右侧百分比字体大小 |
| stroke-width | number/string | 6 | 否 | 进度条线的宽度 |
| color | string | #09BB07 | 否 | 进度条颜色（请使用 activeColor） |
| activeColor | string | #09BB07 | 否 | 已选择的进度条的颜色 |
| backgroundColor | string | #EBEBEB | 否 | 未选择的进度条的颜色 |
| active | boolean | false | 否 | 进度条从左往右的动画 |
| active-mode | string | backwards | 否 | backwards: 动画从头播；forwards：动画从上次结束点接着播 |
| bindactiveend | eventhandle |  | 否 | 动画完成事件 |

## 示例代码

```html
<progress percent="20" show-info />
<progress percent="40" stroke-width="12" />
<progress percent="60" color="pink" />
<progress percent="80" active />
```

![](data:image/png;base64,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)
