# map

地图。相关 api [qa.createMapContext](../api/media/map/qa.createMapContext.html)。

组件属性的长度单位默认为 px，支持传入单位(rpx/px)。

| 属性 | 类型 | <div style="width: 50px">默认值 </div> | <div style="width: 50px">必填 </div> | 说明 |
| --- | --- | --- | --- | --- |
| longitude | number |  | 是 | 中心经度 |
| latitude | number |  | 是 | 中心纬度 |
| scale | number | 16 | 否 | 缩放级别，取值范围为 3-20 |
| markers | Array.\<marker> |  | 否 | 标记点 |
| polyline | Array.\<polyline> |  | 否 | 路线 |
| circles | Array.\<circle> |  | 否 | 圆 |
| controls | Array.\<control> |  | 否 | 控件（即将废弃，建议使用 [cover-view](<cover-view.md>) 代替） |
| include-points | Array.\<point> |  | 否 | 缩放视野以包含所有给定的坐标点 |
| show-location | boolean | false | 否 | 显示带有方向的当前定位点 |
| polygons | Array.\<polygon> |  | 否 | 多边形 |
| show-compass | boolean | false | 否 | 显示指南针 |
| enable-overlooking | boolean | false | 否 | 开启俯视 |
| enable-zoom | boolean | true | 否 | 是否支持缩放 |
| enable-scroll | boolean | true | 否 | 是否支持拖动 |
| enable-rotate | boolean | false | 否 | 是否支持旋转 |
| bindtap | eventhandle |  | 否 | 点击地图时触发 |
| bindmarkertap | eventhandle |  | 否 | 点击标记点时触发，会返回 marker 的 id |
| bindcontroltap | eventhandle |  | 否 | 点击控件时触发，会返回 control 的 id |
| bindcallouttap | eventhandle |  | 否 | 点击标记点对应的气泡时触发，会返回 marker 的 id |
| bindupdated | eventhandle |  | 否 | 在地图渲染更新完成时触发 |
| bindregionchange | eventhandle |  | 否 | 视野发生变化时触发 |
| bindpoitap | eventhandle |  | 否 | 点击地图 poi 点时触发 |

## marker

标记点用于在地图上显示标记的位置

| 属性 | 说明 | 类型 | 必填 | 备注 |
| --- | --- | --- | --- | --- |
| id | 标记点 id | number | 否 | marker 点击事件回调会返回此 id。**建议为每个 marker 设置上 number 类型 id，保证更新 marker 时有更好的性能。** |  |
| latitude | 纬度 | number | 是 | 浮点数，范围 -90 ~ 90 |  |
| longitude | 经度 | number | 是 | 浮点数，范围 -180 ~ 180 |  |
| title | 标注点名 | string | 否 | 点击时显示，callout 存在时将被忽略 |  |
| zIndex | 显示层级 | number | 否 |  |  |
| iconPath | 显示的图标 | string | 是 | 项目目录下的图片路径，支持相对路径写法，以'/'开头则表示相对快应用根目录；也支持临时路径和网络图片 |  |
| rotate | 旋转角度 | number | 否 | 顺时针旋转的角度，范围 0 ~ 360，默认为 0 |  |
| alpha | 标注的透明度 | number | 否 | 默认 1，无透明，范围 0 ~ 1 |  |
| width | 标注图标宽度 | number/string | 否 | 默认为图片实际宽度 |  |
| height | 标注图标高度 | number/string | 否 | 默认为图片实际高度 |  |
| callout | 自定义标记点上方的气泡窗口 | Object | 否 | 支持的属性见下表，可识别换行符。 |  |
| label | 为标记点旁边增加标签 | Object | 否 | 支持的属性见下表，可识别换行符。 |  |
| anchor | 经纬度在标注图标的锚点，默认底边中点 | Object | 否 | {x, y}，x 表示横向(0-1)，y 表示竖向(0-1)。{x: .5, y: 1} 表示底边中点 |  |

## marker 上的气泡 callout

| 属性         | 说明                                      | 类型   |
| ------------ | ----------------------------------------- | ------ |
| content      | 文本                                      | string |
| color        | 文本颜色                                  | string |
| fontSize     | 文字大小                                  | number |
| borderRadius | 边框圆角                                  | number |
| bgColor      | 背景色                                    | string |
| padding      | 文本边缘留白                              | number |
| display      | 'BYCLICK':点击显示; 'ALWAYS':常显         | string |
| textAlign    | 文本对齐方式。有效值: left, right, center | string |

## marker 上的气泡 label

| 属性         | 说明                                      | 类型   |
| ------------ | ----------------------------------------- | ------ |
| content      | 文本                                      | string |
| color        | 文本颜色                                  | string |
| fontSize     | 文字大小                                  | number |
| anchorX      | label 的坐标，原点是 marker 对应的经纬度  | number |
| anchorY      | label 的坐标，原点是 marker 对应的经纬度  | number |
| borderRadius | 边框圆角                                  | number |
| bgColor      | 背景色                                    | string |
| padding      | 文本边缘留白                              | number |
| textAlign    | 文本对齐方式。有效值: left, right, center | string |

## polyline

指定一系列坐标点，从数组第一项连线至最后一项形成曲线

| 属性          | 说明         | 类型    | 必填 | 备注                                 |
| ------------- | ------------ | ------- | ---- | ------------------------------------ |
| points        | 经纬度数组   | array   | 是   | \[{latitude: 0, longitude: 0}\]      |
| color         | 线的颜色     | string  | 否   |                                      |
| width         | 线的宽度     | number  | 否   |                                      |
| dottedLine    | 是否虚线     | boolean | 否   | 默认 false                           |
| arrowLine     | 带箭头的线   | boolean | 否   | 默认 false，开发者工具暂不支持该属性 |
| arrowIconPath | 更换箭头图标 | string  | 否   | 在 arrowLine 为 true 时生效          |

## polygon

指定一系列坐标点，根据 points 坐标数据生成闭合多边形

| 属性        | 说明                | 类型   | 必填 | 备注                            |
| ----------- | ------------------- | ------ | ---- | ------------------------------- |
| points      | 经纬度数组          | array  | 是   | \[{latitude: 0, longitude: 0}\] |
| strokeWidth | 描边的宽度          | number | 否   |                                 |
| strokeColor | 描边的颜色          | string | 否   |                                 |
| fillColor   | 填充颜色            | string | 否   |                                 |
| zIndex      | 设置多边形 Z 轴数值 | number | 否   |                                 |

## circle

在地图上显示圆

| 属性        | 说明       | 类型   | 必填 | 备注                    |
| ----------- | ---------- | ------ | ---- | ----------------------- |
| latitude    | 纬度       | number | 是   | 浮点数，范围 -90 ~ 90   |
| longitude   | 经度       | number | 是   | 浮点数，范围 -180 ~ 180 |
| color       | 描边的颜色 | string | 否   |                         |
| fillColor   | 填充颜色   | string | 否   |                         |
| radius      | 半径       | number | 是   |                         |
| strokeWidth | 描边的宽度 | number | 否   |                         |

## control

| 属性 | 说明 | 类型 | 必填 | 备注 |
| --- | --- | --- | --- | --- |
| id | 控件 id | number | 否 | 在控件点击事件回调会返回此 id |
| position | 控件在地图的位置 | object | 是 | 控件相对地图位置 |
| iconPath | 显示的图标 | string | 是 | 项目目录下的图片路径，支持相对路径写法，以'/'开头则表示相对快应用根目录；也支持临时路径 |
| clickable | 是否可点击 | boolean | 否 | 默认不可点击 |

## position

| 属性   | 说明                 | 类型   | 必填 | 备注           |
| ------ | -------------------- | ------ | ---- | -------------- |
| left   | 距离地图的左边界多远 | number | 否   | 默认为 0       |
| top    | 距离地图的上边界多远 | number | 否   | 默认为 0       |
| width  | 控件宽度             | number | 否   | 默认为图片宽度 |
| height | 控件高度             | number | 否   | 默认为图片高度 |

## bindregionchange 返回值

| 属性 | 说明                     | 类型   | 备注                             |
| ---- | ------------------------ | ------ | -------------------------------- |
| type | 视野变化开始、结束时触发 | string | 视野变化开始为 begin，结束为 end |

## Bug & Tip

::: warning

- 地图中的颜色值 color/bgColor/strokeColor/fillColor 等使用 6 位（8 位）十六进制表示，8 位时后两位表示 alpha 值，如：#000000AA，或者使用'rgb(0,0,0)','rgba(0,0,0,0.8)'表示。
- 地图组件的经纬度必填, 如果不填经纬度则默认值是北京的经纬度。
- `map` 组件使用的经纬度是国测局坐标系，调用 [qa.getLocation](../api/location/qa.getLocation.html) 接口需要指定 `type` 为 `gcj02`
- 请注意[原生组件使用限制](./native-component.html#原生组件的使用限制)。

:::

## 示例代码

```html
<!-- map.qxml -->
<map
  id="map"
  longitude="114.0596562624"
  latitude="22.5681825638"
  controls="{{controls}}"
  bindcontroltap="controltap"
  markers="{{markers}}"
  bindmarkertap="markertap"
  polyline="{{polyline}}"
  bindregionchange="regionchange"
  show-location
  style="width: 100%; height: 300px;"
></map>
```

```js
// map.js
Page({
  data: {
    markers: [
      {
        iconPath: 'marker.jpg',
        id: 0,
        latitude: 22.5681825638,
        longitude: 114.0596562624,
        width: 50,
        height: 50
      }
    ],
    polyline: [
      {
        points: [
          {
            longitude: 114.0596562624,
            latitude: 22.5681825638
          },
          {
            longitude: 119.07,
            latitude: 22.5681825638
          }
        ],
        color: '#000000',
        width: 2,
        dottedLine: true
      }
    ],
    controls: [
      {
        id: 1,
        iconPath: 'control.jpg',
        position: {
          left: 100,
          top: 200,
          width: 50,
          height: 50
        },
        clickable: true
      }
    ]
  },
  regionchange(e) {
    console.log(e.type)
  },
  markertap(e) {
    console.log(e.markerId)
  },
  controltap(e) {
    console.log(e.controlId)
  }
})
```
