# audio

音频

| 属性 | 类型 | <div style="width: 50px">默认值 </div> | <div style="width: 50px">必填 </div> | 说明 |
| --- | --- | --- | --- | --- |
| id | string |  | 否 | audio 组件的唯一标识符 |
| src | string |  | 否 | 要播放音频的资源地址 |
| loop | boolean | false | 否 | 是否循环播放 |
| controls | boolean | false | 否 | 是否显示默认控件 |
| poster | string |  | 否 | 默认控件上的音频封面的图片资源地址，如果 controls 属性值为 false 则设置 poster 无效 |
| name | string | 未知音频 | 否 | 默认控件上的音频名字，如果 controls 属性值为 false 则设置 name 无效 |
| author | string | 未知作者 | 否 | 默认控件上的作者名字，如果 controls 属性值为 false 则设置 author 无效 |
| binderror | eventhandle |  | 否 | 当发生错误时触发 error 事件，detail = {errMsg:MediaError.code} |
| bindplay | eventhandle |  | 否 | 当开始/继续播放时触发 play 事件 |
| bindpause | eventhandle |  | 否 | 当暂停播放时触发 pause 事件 |
| bindtimeupdate | eventhandle |  | 否 | 当播放进度改变时触发 timeupdate 事件，detail = {currentTime, duration} |
| bindended | eventhandle |  | 否 | 当播放到末尾时触发 ended 事件 |

## MediaError.code

| 返回错误码 | 描述               |
| ---------- | ------------------ |
| 1          | 获取资源被用户禁止 |
| 2          | 网络错误           |
| 3          | 解码错误           |
| 4          | 不合适资源         |

## 示例代码

```html
<!-- audio.qxml -->
<view class="page-section page-section-gap" style="text-align: center;">
  <audio
    style="text-align: left"
    src="{{current.src}}"
    poster="{{current.poster}}"
    name="{{current.name}}"
    author="{{current.author}}"
    controls
  ></audio>
</view>
```

```js
// audio.js
Page({
  data: {
    current: {
      poster: 'your_dir_to_poster',
      name: '此时此刻',
      author: '许巍',
      src:
        'your_dir_to_audio_source'
    }
  }
})
```

![](~@assets/audio.png)
