# [UploadTask](UploadTask.html) qa.uploadFile(Object object)

将本地文件上传到服务器端

客户端发起一个 HTTPS POST 请求，其中 `content-type` 为 `multipart/form-data`。

## 参数

### Object object

| 属性 | 类型 | <div style="width: 50px">默认值</div> | <div style="width: 50px">必填</div> | 说明 |
| --- | --- | --- | --- | --- |
| url | string |  | 是 | 服务器地址 |
| filePath | string |  | 是 | 要上传文件的路径 |
| name | string |  | 是 | 文件名 |
| header | Object |  | 否 | HTTP 请求 Header，不支持 Referer |
| formData | Object |  | 否 | HTTP 请求中其他额外的 form data |
| success | function |  | 否 | 接口调用成功的回调函数 |
| fail | function |  | 否 | 接口调用失败的回调函数 |
| complete | function |  | 否 | 接口调用结束的回调函数（调用成功、失败都会执行） |

#### object.success 回调函数

##### 参数

###### Object res

| 属性       | 类型   | 说明                           |
| ---------- | ------ | ------------------------------ |
| data       | string | 服务器返回的数据         |
| statusCode | number | 服务器返回的 HTTP 状态码 |

## 返回值

### [UploadTask](UploadTask.html)

用于监听上传进度进度变化的事件和取消上传的实例

## 示例代码

```js
qa.chooseImage({
  success(res) {
    const tempFilePaths = res.tempFilePaths
    qa.uploadFile({
      url: 'https://example.quickapp.cn/upload', //仅为示例，非真实的接口地址
      filePath: tempFilePaths[0],
      name: 'file',
      formData: {
        user: 'test',
        user2: 'test2'
      },
      success(res) {
        const data = res.data
        //do something
      }
    })
  }
})
```
