# DownloadTask

下载任务实例，可以监听其下载进度变化，以及取消下载

## 方法

### [DownloadTask.abort()](DownloadTask.abort.html)

中断进行中的下载任务

### [DownloadTask.onProgressUpdate(function callback)](./DownloadTask.onProgressUpdate.html)

订阅**下载进度变化事件**回调

### [DownloadTask.offProgressUpdate(function callback)](./DownloadTask.offProgressUpdate.html)

订阅**监听下载进度变化事件**回调

## 示例代码

```js
const downloadTask = qa.downloadFile({
  url: 'http://example.com/audio/123', //仅为示例，并非真实的资源
  success(res) {
    qa.playVoice({
      filePath: res.tempFilePath
    })
  }
})

downloadTask.onProgressUpdate(res => {
  console.log('当前下载进度', res.progress)
  console.log('当前已经下载的数据长度', res.totalBytesWritten)
  console.log('预期需要下载的数据总长度', res.totalBytesExpectedToWrite)
})

downloadTask.abort() // 取消当前下载任务
```
