# qa.getUserInfo(Object object)

> 调用前需要 [用户授权](../../../framework/open-ability/authorize.html) scope.userInfo。

获取用户信息。

## 参数

### Object object

| 属性 | 类型 | <div style="width: 50px">默认值</div> | <div style="width: 50px">必填</div> | 说明 |
| --- | --- | --- | --- | --- |
| success | function |  | 否 | 接口调用成功的回调函数 |
| fail | function |  | 否 | 接口调用失败的回调函数 |
| complete | function |  | 否 | 接口调用结束的回调函数（调用成功、失败都会执行） |

#### object.success 回调函数

##### 参数

###### Object res

| 属性 | 类型 | 说明 |  |
| --- | --- | --- | --- |
| openid | string | 用户的 openid，可能为空 |  |
| id | string | 用户的 user id，可能为空 |  |
| unionid | string | 用户在开放平台上的唯一标示符，本字段在满足一定条件下才会返回（需要在厂商的开放平台上额外申请） |  |
| nickname | string | 用户的昵称，可能为空 |  |
| avatar | Object | 用户的昵称，可能为空 |  |

## [#](#接口调整说明) 接口调整说明

## 示例代码

```js
// 必须是在用户已经授权的情况下调用
qa.getUserInfo({
  success: function(res) {
    var userInfo = res.userInfo
    var nickName = userInfo.nickName
    var avatarUrl = userInfo.avatar
  }
})
```

## 快应用用户信息组件示例代码

```html
<!-- 需要使用 button 来授权登录 -->
<button qa:if="{{canIUse}}" open-type="getUserInfo" bindgetuserinfo="bindGetUserInfo">授权登录</button>
<view qa:else>请升级快应用版本</view>
```

```js
Page({
  data: {
    canIUse: qa.canIUse('button.open-type.getUserInfo')
  },
  onLoad: function() {
    // 查看是否授权
    qa.getSetting({
      success(res) {
        if (res.authSetting['scope.userInfo']) {
          // 已经授权，可以直接调用 getUserInfo 获取头像昵称
          qa.getUserInfo({
            success: function(res) {
              console.log(res)
            }
          })
        }
      }
    })
  },
  bindGetUserInfo(e) {
    console.log(e.detail.userInfo)
  }
})
```
