 # qa.chooseVideo(Object object)

打开系统相机拍摄视频或从手机相册中选视频。

## 参数

### Object object

| 属性 | 类型 | <div style="width: 50px">默认值</div> | <div style="width: 50px">必填</div> | 说明 |
| --- | --- | --- | --- | --- |
| sourceType | Array.\<string> | \['album', 'camera'\] | 否 | 视频选择的来源 |  |
| compressed | boolean | true | 否 | 是否压缩所选择的视频文件 |  |
| maxDuration | number | 60 | 否 | 拍摄视频最长拍摄时间，单位秒 |  |
| camera | string | 'back' | 否 | 默认拉起的是前置或者后置摄像头。部分 Android 手机下由于系统 ROM 不支持无法生效 |  |
| success | function |  | 否 | 接口调用成功的回调函数 |  |
| fail | function |  | 否 | 接口调用失败的回调函数 |  |
| complete | function |  | 否 | 接口调用结束的回调函数（调用成功、失败都会执行） |  |

**object.sourceType 的合法值**

| 值     | 说明             |
| ------ | ---------------- |
| album  | 从相册选择视频   |  |
| camera | 使用相机拍摄视频 |  |

**object.camera 的合法值**

| 值    | 说明               |
| ----- | ------------------ |
| back  | 默认拉起后置摄像头 |  |
| front | 默认拉起前置摄像头 |  |

#### object.success 回调函数

##### 参数

###### Object res

| 属性         | 类型   | 说明                   |
| ------------ | ------ | ---------------------- |
| tempFilePath | string | 选定视频的临时文件路径 |
| duration     | number | 选定视频的时间长度     |
| size         | number | 选定视频的数据量大小   |
| height       | number | 返回选定视频的高度     |
| width        | number | 返回选定视频的宽度     |

## 示例代码

```js
qa.chooseVideo({
  sourceType: ['album', 'camera'],
  maxDuration: 60,
  camera: 'back',
  success(res) {
    console.log(res.tempFilePath)
  }
})
```
