# qa.scanCode(Object object)

调起客户端扫码界面进行扫码

## 参数

### Object object

| 属性 | 类型 | <div style="width: 50px">默认值</div> | <div style="width: 50px">必填</div> | 说明 |
| --- | --- | --- | --- | --- |
| scanType | Array.\<string> | \['barCode', 'qrCode'\] | 否 | 扫码类型 |  |
| success | function |  | 否 | 接口调用成功的回调函数 |  |
| fail | function |  | 否 | 接口调用失败的回调函数 |  |
| complete | function |  | 否 | 接口调用结束的回调函数（调用成功、失败都会执行） |  |

**object.scanType 的合法值**

| 值         | 说明           |
| ---------- | -------------- |
| barCode    | 一维码         |  |
| qrCode     | 二维码         |  |
| datamatrix | Data Matrix 码 |  |

#### object.success 回调函数

##### 参数

###### Object res

| 属性     | 类型   | 说明         |
| -------- | ------ | ------------ |
| result   | string | 所扫码的内容 |
| scanType | string | 所扫码的类型 |

**res.scanType 的合法值**

| 值           | 说明   |
| ------------ | ------ |
| QR_CODE      | 二维码 |  |
| CODABAR      | 一维码 |  |
| CODE_39      | 一维码 |  |
| CODE_93      | 一维码 |  |
| CODE_128     | 一维码 |  |
| DATA_MATRIX  | 二维码 |  |
| EAN_8        | 一维码 |  |
| EAN_13       | 一维码 |  |
| ITF          | 一维码 |  |
| MAXICODE     | 一维码 |  |
| RSS_14       | 一维码 |  |
| RSS_EXPANDED | 一维码 |  |
| UPC_A        | 一维码 |  |
| UPC_E        | 一维码 |  |

## 示例代码

```js
qa.scanCode({
  success(res) {
    console.log(res)
  }
})
```
