# CanvasContext.setTextBaseline(string textBaseline)

设置文字的竖直对齐

## 参数

### string textBaseline

文字的竖直对齐方式

**textBaseline 的合法值**

| 值     | 说明     |
| ------ | -------- |
| top    | 顶部对齐 |  |
| bottom | 底部对齐 |  |
| middle | 居中对齐 |  |
| normal |          |  |

## 示例代码

```js
const ctx = qa.createCanvasContext('myCanvas')

ctx.setStrokeStyle('red')
ctx.moveTo(5, 75)
ctx.lineTo(295, 75)
ctx.stroke()

ctx.setFontSize(20)

ctx.setTextBaseline('top')
ctx.fillText('top', 5, 75)

ctx.setTextBaseline('middle')
ctx.fillText('middle', 50, 75)

ctx.setTextBaseline('bottom')
ctx.fillText('bottom', 120, 75)

ctx.setTextBaseline('normal')
ctx.fillText('normal', 200, 75)

ctx.draw()
```
