# CanvasContext.setGlobalAlpha(number alpha)

设置全局画笔透明度。

## 参数

### number alpha

透明度。范围 0-1，0 表示完全透明，1 表示完全不透明。

## 示例代码

```js
const ctx = qa.createCanvasContext('myCanvas')

ctx.setFillStyle('red')
ctx.fillRect(10, 10, 150, 100)
ctx.setGlobalAlpha(0.2)
ctx.setFillStyle('blue')
ctx.fillRect(50, 50, 150, 100)
ctx.setFillStyle('yellow')
ctx.fillRect(100, 100, 150, 100)

ctx.draw()
```

![](data:image/png;base64,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)
