# qa.getSystemInfo(Object object)

获取系统信息

## 参数

### Object object

| 属性 | 类型 | <div style="width: 50px">必填</div> | <div style="width: 50px">必填</div> | 说明 |
| --- | --- | --- | --- | --- |
| success | function |  | 否 | 接口调用成功的回调函数 |
| fail | function |  | 否 | 接口调用失败的回调函数 |
| complete | function |  | 否 | 接口调用结束的回调函数（调用成功、失败都会执行） |

#### object.success 回调函数

##### 参数

###### Object res

| 属性                   | 类型    | 说明                        |
| ---------------------- | ------- | --------------------------- |
| brand                  | string  | 手机品牌                    |  |
| model                  | string  | 手机型号                    |  |
| pixelRatio             | number  | 手机像素比                  |  |
| screenWidth            | number  | 手机屏幕宽度，单位 px           |  |
| screenHeight           | number  | 手机屏幕高度，单位 px           |  |
| windowWidth            | number  | 手机可使用窗口宽度，单位 px     |  |
| windowHeight           | number  | 手机可使用窗口高度，单位 px     |  |
| statusBarHeight        | number  | 手机状态栏的高度，单位 px       |  |
| language               | string  | 当前手机系统的语言                |  |
| version                | string  | 快应用引擎版本号，字符串类型，比如"1054"        |  |
| SDKVersion             | string  | 快应用引擎版本号, number类型，比如1054 |  |
| system                 | string  | 手机操作系统及版本              |  |
| platform               | string  | 手机平台，比如"android"                  |  |
| fontSizeSetting        | number  | 用户设置字体大小（单位 px）     |  |
| cameraAuthorized       | boolean | 当前快应用是否获得摄像头权限       |  |
| locationAuthorized     | boolean | 当前快应用是否获得定位权限          |  |
| microphoneAuthorized   | boolean | 当前快应用是否获得麦克风权限        |  |
| bluetoothEnabled       | boolean | 手机蓝牙的系统权限开关              |  |
| locationEnabled        | boolean | 手机地理位置的系统开关          |  |
| wifiEnabled            | boolean | 手机Wi-Fi的系统开关            |  |

## 示例代码

```javascript
qa.getSystemInfo({
  success(res) {
    console.log(res.brand)
    console.log(res.pixelRatio)
    console.log(res.screenWidth)
    console.log(res.screenHeight)
    console.log(res.language)
    console.log(res.statusBarHeight)
    console.log(res.platform)
  }
})
```
