## 授权

部分接口需要经过用户授权同意才能调用。我们把这些接口按使用范围分成多个 `scope` ，用户选择对 `scope` 来进行授权，当授权给一个 `scope` 之后，其对应的所有接口都可以直接使用。

此类接口调用时：

- 如果用户未接受或拒绝过此权限，会弹窗询问用户，用户点击同意后方可调用接口；
- 如果用户已授权，可以直接调用接口；
- 如果用户已拒绝授权且勾选了不再询问，则不会出现弹窗，而是直接进入接口 fail 回调。

### 获取用户授权设置

开发者可以使用 [qa.getSetting](../../api/open-api/setting/qa.getSetting.html) 获取用户当前的授权状态。

### 打开设置界面

用户可以在快应用设置界面（「右上角」 - 「关于」 - 「右上角」 - 「设置」）中控制对该快应用的授权状态。


### 提前发起授权请求

开发者可以使用 [qa.authorize](../../api/open-api/authorize/qa.authorize.html) 在调用需授权 API 之前，提前向用户发起授权请求。

### scope 列表

| scope | 对应接口 | 描述 |
| --- | --- | --- |
| scope.userInfo | [qa.getUserInfo](../../api/open-api/user-info/qa.getUserInfo.html) | 用户信息 |
| scope.userLocation | [qa.getLocation](../../api/location/qa.getLocation.html), [qa.chooseLocation](../../api/location/qa.chooseLocation.html) | 地理位置 |
| scope.record | [qa.startRecord](../../api/media/recorder/qa.startRecord.html) | 录音功能 |
| scope.writePhotosAlbum | [qa.saveImageToPhotosAlbum](../../api/media/image/qa.saveImageToPhotosAlbum.html), [qa.saveVideoToPhotosAlbum](../../api/media/video/qa.saveVideoToPhotosAlbum.html) | 保存到相册 |

### 授权有效期

一旦用户明确同意或拒绝过授权，其授权关系会记录在后台，直到用户主动删除快应用。

### 最佳实践

在真正需要使用授权接口时，才向用户发起授权申请，并在授权申请中说明清楚要使用该功能的理由。

### 注意事项

1. `qa.authorize({scope: "scope.userInfo"})`，不会弹出授权窗口，请使用 [`<button open-type="getUserInfo"/>`](../../component/button.html)
2. 需要授权 `scope.userLocation` 时必须[配置地理位置用途说明](../../reference/configuration/app.html#permission)。
