# 组件扩展

`Behavior()` 构造器提供了新的定义段 `definitionFilter` 用于自定义组件的扩展。`definitionFilter` 的主要作用是允许修改自定义组件的定义段。

## 简单示例

通过一个简单的例子看看自定义组件扩展的效果：

```js
// behavior.js
module.exports = Behavior({
  definitionFilter(defFields) {
    defFields.data.name = 'behavior'
  }
})

// component.js
Component({
  data: {
    name: 'component'
  },
  behaviors: [require('behavior.js')],
  ready() {
    console.log(this.data.name) // 输出 behavior 而不是 component
  }
})
```

## definitionFilter

`definitionFilter` 是一个函数，在被调用时会注入两个参数，第一个参数是使用该 behavior 的 `component/behavior` 的定义对象，第二个参数是该 behavior 所使用的 behavior 的 `definitionFilter` 函数列表。

以下举个例子来说明：

```js
// behaviorC.js
module.exports = Behavior({
  definitionFilter(defFields, definitionFilterArr) {}
})

// behaviorB.js
module.exports = Behavior({
  behaviors: [require('behaviorC.js')],
  definitionFilter(defFields, definitionFilterArr) {
    // definitionFilterArr[0] 即为 behaviorC 的 definitionFilter 方法
  }
})

// behaviorA.js
module.exports = Behavior({
  behaviors: [require('behaviorB.js')],
  definitionFilter(defFields, definitionFilterArr) {
    // definitionFilterArr[0] 即为 behaviorB 的 definitionFilter 方法
  }
})

// component.js
Component({
  behaviors: [require('behaviorA.js')]
})
```

例子中声明了 1 个自定义组件和 3 个 behavior，每个 behavior 都定义了扩展 `definitionFilter` 。behavior 定义的逻辑如下：

1. 定义 behaviorB 时：会调用 behaviorC 的 `definitionFilter` 函数，其中 `defFields` 参数是 behaviorB 的定义段， `definitionFilterArr` 参数为空数组，因为 behaviorC 没有使用其他的 behavior 。
2. 定义 behaviorA 时：会调用 behaviorB 的 `definitionFilter` 函数，其中 `defFields` 参数是 behaviorA 的定义段， `definitionFilterArr` 参数是一个长度为 1 的数组，`definitionFilterArr[0]` 即为 behaviorC 的 `definitionFilter` 函数，因为 behaviorB 使用了 behaviorC。开发者可以自行决定要不要调用 behaviorC 的 `definitionFilter` 函数，如 `definitionFilterArr[0](defFields)`。
3. 定义 component 时：会调用 behaviorA 的 `definitionFilter` 函数。

总结一下，当 A 使用了 B 时，A 声明就会调用 B 的 `definitionFilter` 函数并传入 A 的定义对象让 B 去过滤。如果 B 还使用了 C 和 D ，那么 B 的 `definitionFilter` 内还可以获取到 C 和 D 的 `definitionFilter` 函数。
