# 逻辑层

快应用框架的逻辑层使用 `V8` 引擎作为 `JavaScript` 代码的运行环境。

逻辑层将数据进行处理后发送给渲染层，同时处理渲染层的事件反馈。

开发者写的所有代码最终将会打包成一份 `JavaScript` 文件，并在快应用启动的时候运行，直到快应用销毁。

在 `JavaScript` 的基础上，我们增加了额外的功能，帮助开发者快速开发应用，例如：

- 增加 `App` 和 `Page` 方法，分别用于[程序注册](./app.html)和[页面注册](./page.html)。
- 增加 `getApp` 和 `getCurrentPages` 方法，分别用于获取 `App` 实例和当前页面栈。
- 提供功能丰富的 [API](api.html)。
- 提供 `JavaScript` [模块化](./module.html#模块化)能力，每个页面 js 有独立的[作用域](./module.html#文件作用域)。

**注意：快应用框架的逻辑层并非运行在浏览器中，因此浏览器中特有的能力都无法使用，如 `window`，`document` 等。**
