# video

视频组件。相关 的api介绍：[qa.createVideoContext](../api/media/video/qa.createVideoContext.html)

| 属性 | 类型 | <div style="width: 50px">默认值 </div> | <div style="width: 50px">必填 </div> | 说明 |
| --- | --- | --- | --- | --- |
| src | string |  | 是 | 要播放视频的资源地址 |
| controls | boolean | true | 否 | 是否显示默认播放控制界面（播放/暂停按钮、播放进度、时间） |
| autoplay | boolean | false | 否 | 是否自动播放视频 |
| object-fit | string | contain | 否 | 当视频大小与 video 容器大小不一致时，视频的呈现形式 |
| poster | string |  | 否 | 视频封面的图片网络资源地址。 |
| bindplay | eventhandle |  | 否 | 当开始/继续播放时触发 play 事件 |
| bindpause | eventhandle |  | 否 | 播放暂停时触发 pause 事件 |
| bindended | eventhandle |  | 否 | 播放到末尾时触发 ended 事件 |
| bindtimeupdate | eventhandle |  | 否 | 播放进度变化时触发，event.detail = {currentTime, duration} 。触发频率为 250ms 一次 |
| bindfullscreenchange | eventhandle |  | 否 | 视频进入和退出全屏时触发，event.detail = {fullScreen, direction}，direction 有效值为 vertical 或 horizontal |
| binderror | eventhandle |  | 否 | 视频播放出错时触发 |

**object-fit 的合法值**

| 值      | 说明 |
| ------- | ---- |
| contain | 包含 |
| fill    | 填充 |
| cover   | 覆盖 |

## Bug & Tip

::: warning

- [video](video.html) 默认宽度 300px、高度 225px，可通过 css 设置宽高。

:::

#### 支持的格式

| 格式 | Android |
| ---- | ------- |
| mp4  | √       |
| mov  | x       |
| m4v  | x       |
| 3gp  | √       |
| avi  | x       |
| m3u8 | √       |
| webm | √       |
| Ogg  | √       |
| WAV  | √       |

#### 支持的编码格式

| 格式   | Android |
| ------ | ------- |
| H.263  | √       |
| H.264  | √       |
| HEVC   | √       |
| MPEG-4 | √       |

## 示例代码

```html
<view class="section tc">
  <video
    id="myVideo"
    src="http://commondatastorage.googleapis.com/gtv-videos-bucket/sample/ForBiggerBlazes.mp4"
    controls
  ></video>
  <view class="btn-area">
    <button bindtap="bindButtonTap">获取视频</button>
  </view>
</view>
```

```js
Page({
  data: {
    src: ''
  },
  bindButtonTap: function() {
    var that = this
    qa.chooseVideo({
      sourceType: ['album', 'camera'],
      maxDuration: 60,
      camera: ['front', 'back'],
      success: function(res) {
        that.setData({
          src: res.tempFilePath
        })
      }
    })
  }
})
```
