# radio

单选项目。

| 属性 | 类型 | <div style="width: 50px">默认值 </div> | <div style="width: 50px">必填 </div> | 说明 |
| --- | --- | --- | --- | --- |
| value | string |  | 否 | [radio](radio.html) 组件的标识。当该[radio](radio.html) 被选中时，[radio-group](radio-group.html) 的 change 事件会携带[radio](radio.html)的 value |  |
| checked | boolean | false | 否 | 当前是否选中 |  |
| disabled | boolean | false | 否 | 是否禁用 |  |
| color | string | #09BB07 | 否 | radio 的颜色，同 css 的 color |  |

## 示例代码

```html
<radio-group class="radio-group" bindchange="radioChange">
  <label class="radio" qa:for="{{items}}">
    <radio value="{{item.name}}" checked="{{item.checked}}" />{{item.value}}
  </label>
</radio-group>
```

```js
Page({
  data: {
    items: [
      { name: 'USA', value: '美国' },
      { name: 'CHN', value: '中国', checked: 'true' },
      { name: 'BRA', value: '巴西' },
      { name: 'JPN', value: '日本' },
      { name: 'ENG', value: '英国' },
      { name: 'TUR', value: '法国' }
    ]
  },
  radioChange: function(e) {
    console.log('radio发生change事件，携带value值为：', e.detail.value)
  }
})
```

![](data:image/png;base64,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)
