# image

图片。支持 JPG、PNG、SVG 格式

| 属性 | 类型 | <div style="width: 50px">默认值 </div> | <div style="width: 50px">必填 </div> | 说明 |
| --- | --- | --- | --- | --- |
| src | string |  | 否 | 图片资源地址 |
| mode | string | scaleToFill | 否 | 图片裁剪、缩放的模式 |
| lazy-load | boolean | false | 否 | 图片懒加载，在即将进入一定范围（上下三屏）时才开始加载 |
| binderror | eventhandle |  | 否 | 当错误发生时触发， event.detail = {errMsg} |
| bindload | eventhandle |  | 否 | 当图片载入完毕时触发，event.detail = {height, width} |

**mode 的合法值**

| 值 | 说明 |
| --- | --- |
| scaleToFill | 缩放模式，不保持纵横比缩放图片，使图片的宽高完全拉伸至填满 image 元素 |
| aspectFit | 缩放模式，保持纵横比缩放图片，使图片的长边能完全显示出来。也就是说，可以完整地将图片显示出来。 |
| aspectFill | 缩放模式，保持纵横比缩放图片，只保证图片的短边能完全显示出来。也就是说，图片通常只在水平或垂直方向是完整的，另一个方向将会发生截取。 |
| widthFix | 缩放模式，宽度不变，高度自动变化，保持原图宽高比不变 |
| top | 裁剪模式，不缩放图片，只显示图片的顶部区域 |
| bottom | 裁剪模式，不缩放图片，只显示图片的底部区域 |
| center | 裁剪模式，不缩放图片，只显示图片的中间区域 |
| left | 裁剪模式，不缩放图片，只显示图片的左边区域 |
| right | 裁剪模式，不缩放图片，只显示图片的右边区域 |
| top left | 裁剪模式，不缩放图片，只显示图片的左上边区域 |
| top right | 裁剪模式，不缩放图片，只显示图片的右上边区域 |
| bottom left | 裁剪模式，不缩放图片，只显示图片的左下边区域 |
| bottom right | 裁剪模式，不缩放图片，只显示图片的右下边区域 |

## Bug & Tip

::: warning

- image 组件默认宽度 300px、高度 225px

:::

## 示例代码

```html
<view class="page">
  <view class="page__hd">
    <text class="page__title">image</text>
    <text class="page__desc">图片</text>
  </view>
  <view class="page__bd">
    <view class="section section_gap" qa:for="{{array}}" qa:for-item="item">
      <view class="section__title">{{item.text}}</view>
      <view class="section__ctn">
        <image
          style="width: 200px; height: 200px; background-color: #eeeeee;"
          mode="{{item.mode}}"
          src="{{src}}"
        ></image>
      </view>
    </view>
  </view>
</view>
```

```js
Page({
  data: {
    array: [
      {
        mode: 'scaleToFill',
        text: 'scaleToFill：不保持纵横比缩放图片，使图片完全适应'
      },
      {
        mode: 'aspectFit',
        text: 'aspectFit：保持纵横比缩放图片，使图片的长边能完全显示出来'
      },
      {
        mode: 'aspectFill',
        text: 'aspectFill：保持纵横比缩放图片，只保证图片的短边能完全显示出来'
      },
      {
        mode: 'top',
        text: 'top：不缩放图片，只显示图片的顶部区域'
      },
      {
        mode: 'bottom',
        text: 'bottom：不缩放图片，只显示图片的底部区域'
      },
      {
        mode: 'center',
        text: 'center：不缩放图片，只显示图片的中间区域'
      },
      {
        mode: 'left',
        text: 'left：不缩放图片，只显示图片的左边区域'
      },
      {
        mode: 'right',
        text: 'right：不缩放图片，只显示图片的右边边区域'
      },
      {
        mode: 'top left',
        text: 'top left：不缩放图片，只显示图片的左上边区域'
      },
      {
        mode: 'top right',
        text: 'top right：不缩放图片，只显示图片的右上边区域'
      },
      {
        mode: 'bottom left',
        text: 'bottom left：不缩放图片，只显示图片的左下边区域'
      },
      {
        mode: 'bottom right',
        text: 'bottom right：不缩放图片，只显示图片的右下边区域'
      }
    ],
    src: '../resources/cat.jpg'
  },
  imageError: function(e) {
    console.log('image3发生error事件，携带值为', e.detail.errMsg)
  }
})
```

##### 原图

![image](~@assets/origin.png)

##### scaleToFill

不保持纵横比缩放图片，使图片完全适应

![image](~@assets/scaleToFill.png)

##### aspectFit

保持纵横比缩放图片，使图片的长边能完全显示出来

![image](~@assets/aspectFit.png)

##### aspectFill

保持纵横比缩放图片，只保证图片的短边能完全显示出来

![image](~@assets/aspectFill.png)

##### top

不缩放图片，只显示图片的顶部区域

![image](~@assets/top.png)

##### bottom

不缩放图片，只显示图片的底部区域

![image](~@assets/bottom.png)

##### center

不缩放图片，只显示图片的中间区域

![image](~@assets/center.png)

##### left

不缩放图片，只显示图片的左边区域

![image](~@assets/left.png)

##### right

不缩放图片，只显示图片的右边边区域

![image](~@assets/right.png)

##### top left

不缩放图片，只显示图片的左上边区域

![image](~@assets/topLeft.png)

##### top right

不缩放图片，只显示图片的右上边区域

![image](~@assets/topRight.png)

##### bottom left

不缩放图片，只显示图片的左下边区域

![image](~@assets/bottomLeft.png)

##### bottom right

不缩放图片，只显示图片的右下边区域

![image](~@assets/bottomRight.png)
