# qa.showLoading(Object object)

显示 loading 提示框。需主动调用 qa.hideLoading 才能关闭提示框

## 参数

### Object object

| 属性 | 类型 | <div style="width: 50px">默认值</div> | <div style="width: 50px">必填</div> | 说明 |
| --- | --- | --- | --- | --- |
| title | string |  | 是 | 提示的内容 |
| mask | boolean | false | 否 | 是否显示透明蒙层，防止触摸穿透 |
| success | function |  | 否 | 接口调用成功的回调函数 |
| fail | function |  | 否 | 接口调用失败的回调函数 |
| complete | function |  | 否 | 接口调用结束的回调函数（调用成功、失败都会执行） |

## 示例代码

```js
qa.showLoading({
  title: '加载中'
})

setTimeout(function() {
  qa.hideLoading()
}, 2000)
```

## 注意

::: warning

- [qa.showLoading](qa.showLoading.html) 和 [qa.showToast](qa.showToast.html) 同时只能显示一个
- [qa.showLoading](qa.showLoading.html) 应与 [qa.hideLoading](qa.hideLoading.html) 配对使用

:::
