const path = require('path')
module.exports = {
  port: 8080,
  head: [
    ['link', { rel: 'icon', href: '/quickapp.ico' }],
    ['link', { rel: 'manifest', href: '/manifest.json' }],
  ],
  // plug pwa here
  plugins: [
      [
        'seo',
        { 
            //...
            customMeta: (add, context) => {

              const {
                  $site, // Site configs provided by Vuepress
                  title
              } = context
              add('keyword', '快应用light版, quickapp, fastapp, 小程序, 原生应用, 即点即用' + title + ',' + $site.title)
              add('description', '快应用light版官方文档, 标准是由主流手机厂商组成的快应用联盟联合制定,其标准的诞生将在研发接口、能力接入、开发者服务等层面建设标准平台，以平台化的生态模式对个人开发者和企业开发者全品类开放。快应用具备传统 APP 完整的应用体验，无需安装、即点即用；覆盖 10 亿设备，与操作系统深度集成，探索新型应用场景。' + '本章的内容为' + title)
          },
        }
      ],
      [
        '@vuepress/google-analytics',
        {
          'ga': 'UA-151323982-1'
        }
      ],
      
      ['@vuepress/pwa', {
        serviceWorker: true,
        updatePopup: true
      }]
  ],
  title: '快应用 (Light) 版',
  description: 'Documentation',
  searchMaxSuggestions: 20,
  markdown: {
    anchor: { permalink: true, permalinkBefore: true, permalinkSymbol: '#' },
    lineNumbers: true,
    toc: { includeLevel: [2, 3] }
  },
  configureWebpack: {
    resolve: {
      alias: {
        '@assets': path.resolve(__dirname, '../assets')
      }
    }
  },
  shouldPrefetch: _ => {
    return false
  },
  themeConfig: {
    activeHeaderLinks: true,
    displayAllHeaders: true,
    algolia: {
      apiKey: 'e9f305113e5c85f3c52fe7c4c69bdc59',
      indexName: 'hellohub'
    },
    searchMaxSuggestions: 15,
    smoothScroll: true,
    nav: [
      { text: '教程', link: '/framework/' },
      { text: '框架', link: '/reference/' },
      { text: '组件', link: '/component/' },
      { text: 'API', link: '/api/' }
    ],
    sidebar: {
      '/api/': [
        {
          title: '基础', // required
          collapsable: true, // optional, defaults to true
          sidebarDepth: 1, // optional, defaults to 1
          sidebar: 'auto',
          children: [
            {
              title: 'qa.canIUse',
              path: '/api/base/qa.canIUse.md',
              collapsable: true
            },
            {
              title: 'qa.arrayBufferToBase64',
              path: '/api/base/qa.arrayBufferToBase64.md',
              collapsable: true
            },
            {
              title: 'qa.base64ToArrayBuffer',
              path: '/api/base/qa.base64ToArrayBuffer.md',
              collapsable: true
            },
            {
              title: 'qa.setTrustedUrls',
              path: '/api/base/qa.setTrustedUrls.md',
              collapsable: true
            },
            {
              title: '定时器',
              collapsable: true,
              sidebarDepth: 1,
              children: [
                {
                  title: 'clearInterval',
                  path: '/api/base/timer/clearInterval.md',
                  collapsable: true
                },
                {
                  title: 'setInterval',
                  path: '/api/base/timer/setInterval.md',
                  collapsable: true
                },
                {
                  title: 'clearTimeout',
                  path: '/api/base/timer/clearTimeout.md',
                  collapsable: true
                },
                {
                  title: 'setTimeout',
                  path: '/api/base/timer/setTimeout.md',
                  collapsable: true
                }
              ]
            },
            {
              title: '应用级事件',
              collapsable: true,
              sidebarDepth: 1,
              children: [
                {
                  title: 'qa.offAppHide',
                  path: '/api/base/app/qa.offAppHide.md',
                  collapsable: true
                },
                {
                  title: 'qa.offAppShow',
                  path: '/api/base/app/qa.offAppShow.md',
                  collapsable: true
                },
                {
                  title: 'qa.offError',
                  path: '/api/base/app/qa.offError.md',
                  collapsable: true
                },
                {
                  title: 'qa.offPageNotFound',
                  path: '/api/base/app/qa.offPageNotFound.md',
                  collapsable: true
                },
                {
                  title: 'qa.onAppHide',
                  path: '/api/base/app/qa.onAppHide.md',
                  collapsable: true
                },
                {
                  title: 'qa.onAppShow',
                  path: '/api/base/app/qa.onAppShow.md',
                  collapsable: true
                },
                {
                  title: 'qa.onError',
                  path: '/api/base/app/qa.onError.md',
                  collapsable: true
                }
              ]
            },
            {
              title: '系统',
              collapsable: true,
              sidebarDepth: 1,
              children: [
                {
                  title: 'qa.getSystemInfo',
                  path: '/api/base/system/qa.getSystemInfo.md',
                  collapsable: true
                },
                {
                  title: 'qa.getSystemInfoSync',
                  path: '/api/base/system/qa.getSystemInfoSync.md',
                  collapsable: true
                }
              ]
            },
            {
              title: '调试',
              collapsable: true,
              sidebarDepth: 1,
              children: [
                {
                  title: 'qa.setEnableDebug',
                  path: '/api/base/debug/qa.setEnableDebug.md',
                  collapsable: true
                },
                {
                  title: 'console',
                  collapsable: true,
                  sidebarDepth: 1,
                  children: [
                    {
                      title: 'console',
                      path: '/api/base/debug/console.md',
                      collapsable: true,
                      sidebarDepth: 1
                    },
                    {
                      title: 'console.debug',
                      path: '/api/base/debug/console.debug.md',
                      collapsable: true,
                      sidebarDepth: 1
                    },
                    {
                      title: 'console.error',
                      path: '/api/base/debug/console.error.md',
                      collapsable: true,
                      sidebarDepth: 1
                    },
                    {
                      title: 'console.group',
                      path: '/api/base/debug/console.group.md',
                      collapsable: true,
                      sidebarDepth: 1
                    },
                    {
                      title: 'console.groupEnd',
                      path: '/api/base/debug/console.groupEnd.md',
                      collapsable: true,
                      sidebarDepth: 1
                    },
                    {
                      title: 'console.info',
                      path: '/api/base/debug/console.info.md',
                      collapsable: true,
                      sidebarDepth: 1
                    },
                    {
                      title: 'console.log',
                      path: '/api/base/debug/console.log.md',
                      collapsable: true,
                      sidebarDepth: 1
                    },
                    {
                      title: 'console.warn',
                      path: '/api/base/debug/console.warn.md',
                      collapsable: true,
                      sidebarDepth: 1
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          title: '画布',
          collapsable: true,
          sidebarDepth: 1,
          children: [
            {
              title: 'qa.canvasGetImageData',
              path: '/api/canvas/qa.canvasGetImageData.md',
              collapsable: true
            },
            {
              title: 'qa.canvasPutImageData',
              path: '/api/canvas/qa.canvasPutImageData.md',
              collapsable: true
            },
            {
              title: 'qa.createCanvasContext',
              path: '/api/canvas/qa.createCanvasContext.md',
              collapsable: true
            },
            {
              title: 'CanvasContext',
              collapsable: true,
              sidebarDepth: 1,
              children: [
                {
                  title: 'CanvasContext',
                  path: '/api/canvas/CanvasContext.md',
                  collapsable: true
                },
                {
                  title: 'CanvasContext.arc',
                  path: '/api/canvas/CanvasContext.arc.md',
                  collapsable: true
                },
                {
                  title: 'CanvasContext.arcTo',
                  path: '/api/canvas/CanvasContext.arcTo.md',
                  collapsable: true
                },
                {
                  title: 'CanvasContext.beginPath',
                  path: '/api/canvas/CanvasContext.beginPath.md',
                  collapsable: true
                },
                {
                  title: 'CanvasContext.bezierCurveTo',
                  path: '/api/canvas/CanvasContext.bezierCurveTo.md',
                  collapsable: true
                },
                {
                  title: 'CanvasContext.clearRect',
                  path: '/api/canvas/CanvasContext.clearRect.md',
                  collapsable: true
                },
                {
                  title: 'CanvasContext.clip',
                  path: '/api/canvas/CanvasContext.clip.md',
                  collapsable: true
                },
                {
                  title: 'CanvasContext.closePath',
                  path: '/api/canvas/CanvasContext.closePath.md',
                  collapsable: true
                },
                {
                  title: 'CanvasContext.createCircularGradient',
                  path: '/api/canvas/CanvasContext.createCircularGradient.md',
                  collapsable: true
                },
                {
                  title: 'CanvasContext.createLinearGradient',
                  path: '/api/canvas/CanvasContext.createLinearGradient.md',
                  collapsable: true
                },
                {
                  title: 'CanvasContext.createPattern',
                  path: '/api/canvas/CanvasContext.createPattern.md',
                  collapsable: true
                },
                {
                  title: 'CanvasContext.draw',
                  path: '/api/canvas/CanvasContext.draw.md',
                  collapsable: true
                },
                {
                  title: 'CanvasContext.drawImage',
                  path: '/api/canvas/CanvasContext.drawImage.md',
                  collapsable: true
                },
                {
                  title: 'CanvasContext.fill',
                  path: '/api/canvas/CanvasContext.fill.md',
                  collapsable: true
                },
                {
                  title: 'CanvasContext.fillRect',
                  path: '/api/canvas/CanvasContext.fillRect.md',
                  collapsable: true
                },
                {
                  title: 'CanvasContext.fillText',
                  path: '/api/canvas/CanvasContext.fillText.md',
                  collapsable: true
                },
                {
                  title: 'CanvasContext.lineTo',
                  path: '/api/canvas/CanvasContext.lineTo.md',
                  collapsable: true
                },
                {
                  title: 'CanvasContext.measureText',
                  path: '/api/canvas/CanvasContext.measureText.md',
                  collapsable: true
                },
                {
                  title: 'CanvasContext.moveTo',
                  path: '/api/canvas/CanvasContext.moveTo.md',
                  collapsable: true
                },
                {
                  title: 'CanvasContext.quadraticCurveTo',
                  path: '/api/canvas/CanvasContext.quadraticCurveTo.md',
                  collapsable: true
                },
                {
                  title: 'CanvasContext.rect',
                  path: '/api/canvas/CanvasContext.rect.md',
                  collapsable: true
                },
                {
                  title: 'CanvasContext.restore',
                  path: '/api/canvas/CanvasContext.restore.md',
                  collapsable: true
                },
                {
                  title: 'CanvasContext.rotate',
                  path: '/api/canvas/CanvasContext.rotate.md',
                  collapsable: true
                },
                {
                  title: 'CanvasContext.save',
                  path: '/api/canvas/CanvasContext.save.md',
                  collapsable: true
                },
                {
                  title: 'CanvasContext.scale',
                  path: '/api/canvas/CanvasContext.scale.md',
                  collapsable: true
                },
                {
                  title: 'CanvasContext.setFillStyle',
                  path: '/api/canvas/CanvasContext.setFillStyle.md',
                  collapsable: true
                },
                {
                  title: 'CanvasContext.setFontSize',
                  path: '/api/canvas/CanvasContext.setFontSize.md',
                  collapsable: true
                },
                {
                  title: 'CanvasContext.setGlobalAlpha',
                  path: '/api/canvas/CanvasContext.setGlobalAlpha.md',
                  collapsable: true
                },
                {
                  title: 'CanvasContext.setLineCap',
                  path: '/api/canvas/CanvasContext.setLineCap.md',
                  collapsable: true
                },
                {
                  title: 'CanvasContext.setLineDash',
                  path: '/api/canvas/CanvasContext.setLineDash.md',
                  collapsable: true
                },
                {
                  title: 'CanvasContext.setLineJoin',
                  path: '/api/canvas/CanvasContext.setLineJoin.md',
                  collapsable: true
                },
                {
                  title: 'CanvasContext.setLineWidth',
                  path: '/api/canvas/CanvasContext.setLineWidth.md',
                  collapsable: true
                },
                {
                  title: 'CanvasContext.setMiterLimit',
                  path: '/api/canvas/CanvasContext.setMiterLimit.md',
                  collapsable: true
                },
                {
                  title: 'CanvasContext.setStrokeStyle',
                  path: '/api/canvas/CanvasContext.setStrokeStyle.md',
                  collapsable: true
                },
                {
                  title: 'CanvasContext.setTextAlign',
                  path: '/api/canvas/CanvasContext.setTextAlign.md',
                  collapsable: true
                },
                {
                  title: 'CanvasContext.setTextBaseline',
                  path: '/api/canvas/CanvasContext.setTextBaseline.md',
                  collapsable: true
                },
                {
                  title: 'CanvasContext.setTransform',
                  path: '/api/canvas/CanvasContext.setTransform.md',
                  collapsable: true
                },
                {
                  title: 'CanvasContext.stroke',
                  path: '/api/canvas/CanvasContext.stroke.md',
                  collapsable: true
                },
                {
                  title: 'CanvasContext.strokeRect',
                  path: '/api/canvas/CanvasContext.strokeRect.md',
                  collapsable: true
                },
                {
                  title: 'CanvasContext.strokeText',
                  path: '/api/canvas/CanvasContext.strokeText.md',
                  collapsable: true
                },
                {
                  title: 'CanvasContext.transform',
                  path: '/api/canvas/CanvasContext.transform.md',
                  collapsable: true
                },
                {
                  title: 'CanvasContext.translate',
                  path: '/api/canvas/CanvasContext.translate.md',
                  collapsable: true
                }
              ]
            },
            {
              title: 'CanvasGradient.addColorStop',
              path: '/api/canvas/CanvasGradient.addColorStop.md',
              collapsable: true
            },
            {
              title: 'CanvasGradient',
              path: '/api/canvas/CanvasGradient.md',
              collapsable: true
            },
            {
              title: 'Image',
              path: '/api/canvas/Image.md',
              collapsable: true
            },
            {
              title: 'Color',
              path: '/api/canvas/Color.md',
              collapsable: true
            }
          ]
        },
        {
          title: '路由', // required
          collapsable: true, // optional, defaults to true
          sidebarDepth: 1, // optional, defaults to 1
          children: [
            {
              title: 'qa.navigateBack',
              path: '/api/route/qa.navigateBack.md',
              collapsable: true
            },
            {
              title: 'qa.navigateTo',
              path: '/api/route/qa.navigateTo.md',
              collapsable: true
            },
            {
              title: 'qa.reLaunch',
              path: '/api/route/qa.reLaunch.md',
              collapsable: true
            },
            {
              title: 'qa.redirectTo',
              path: '/api/route/qa.redirectTo.md',
              collapsable: true
            },
            {
              title: 'qa.switchTab',
              path: '/api/route/qa.switchTab.md',
              collapsable: true
            }
          ]
        },
        {
          title: '界面', // required
          collapsable: true, // optional, defaults to true
          sidebarDepth: 1, // optional, defaults to 1
          children: [
            {
              title: 'qa.createAnimation',
              path: '/api/ui/animation/qa.createAnimation.md',
              collapsable: true,
              sidebarDepth: 1
            },
            {
              title: 'Animation',
              sidebarDepth: 1,
              collapsable: true,
              children: [
                {
                  title: 'Animation',
                  path: '/api/ui/animation/Animation.md',
                  collapsable: true,
                  sidebarDepth: 1
                },
                {
                  title: 'Animation.backgroundColor',
                  path: '/api/ui/animation/Animation.backgroundColor.md',
                  collapsable: true,
                  sidebarDepth: 1
                },
                {
                  title: 'Animation.bottom',
                  path: '/api/ui/animation/Animation.bottom.md',
                  collapsable: true,
                  sidebarDepth: 1
                },
                {
                  title: 'Animation.export',
                  path: '/api/ui/animation/Animation.export.md',
                  collapsable: true,
                  sidebarDepth: 1
                },
                {
                  title: 'Animation.height',
                  path: '/api/ui/animation/Animation.height.md',
                  collapsable: true,
                  sidebarDepth: 1
                },
                {
                  title: 'Animation.left',
                  path: '/api/ui/animation/Animation.left.md',
                  collapsable: true,
                  sidebarDepth: 1
                },
                {
                  title: 'Animation.matrix',
                  path: '/api/ui/animation/Animation.matrix.md',
                  collapsable: true,
                  sidebarDepth: 1
                },
                {
                  title: 'Animation.matrix3d',
                  path: '/api/ui/animation/Animation.matrix3d.md',
                  collapsable: true,
                  sidebarDepth: 1
                },

                {
                  title: 'Animation.opacity',
                  path: '/api/ui/animation/Animation.opacity.md',
                  collapsable: true,
                  sidebarDepth: 1
                },
                {
                  title: 'Animation.right',
                  path: '/api/ui/animation/Animation.right.md',
                  collapsable: true,
                  sidebarDepth: 1
                },
                {
                  title: 'Animation.rotate',
                  path: '/api/ui/animation/Animation.rotate.md',
                  collapsable: true,
                  sidebarDepth: 1
                },
                {
                  title: 'Animation.rotate3d',
                  path: '/api/ui/animation/Animation.rotate3d.md',
                  collapsable: true,
                  sidebarDepth: 1
                },
                {
                  title: 'Animation.rotateX',
                  path: '/api/ui/animation/Animation.rotateX.md',
                  collapsable: true,
                  sidebarDepth: 1
                },
                {
                  title: 'Animation.rotateY',
                  path: '/api/ui/animation/Animation.rotateY.md',
                  collapsable: true,
                  sidebarDepth: 1
                },
                {
                  title: 'Animation.rotateZ',
                  path: '/api/ui/animation/Animation.rotateZ.md',
                  collapsable: true,
                  sidebarDepth: 1
                },
                {
                  title: 'Animation.scale',
                  path: '/api/ui/animation/Animation.scale.md',
                  collapsable: true,
                  sidebarDepth: 1
                },
                {
                  title: 'Animation.scale3d',
                  path: '/api/ui/animation/Animation.scale3d.md',
                  collapsable: true,
                  sidebarDepth: 1
                },
                {
                  title: 'Animation.scaleX',
                  path: '/api/ui/animation/Animation.scaleX.md',
                  collapsable: true,
                  sidebarDepth: 1
                },
                {
                  title: 'Animation.scaleY',
                  path: '/api/ui/animation/Animation.scaleY.md',
                  collapsable: true,
                  sidebarDepth: 1
                },
                {
                  title: 'Animation.scaleZ',
                  path: '/api/ui/animation/Animation.scaleZ.md',
                  collapsable: true,
                  sidebarDepth: 1
                },
                {
                  title: 'Animation.skew',
                  path: '/api/ui/animation/Animation.skew.md',
                  collapsable: true,
                  sidebarDepth: 1
                },
                {
                  title: 'Animation.skewX',
                  path: '/api/ui/animation/Animation.skewX.md',
                  collapsable: true,
                  sidebarDepth: 1
                },
                {
                  title: 'Animation.skewY',
                  path: '/api/ui/animation/Animation.skewY.md',
                  collapsable: true,
                  sidebarDepth: 1
                },
                {
                  title: 'Animation.step',
                  path: '/api/ui/animation/Animation.step.md',
                  collapsable: true,
                  sidebarDepth: 1
                },
                {
                  title: 'Animation.top',
                  path: '/api/ui/animation/Animation.top.md',
                  collapsable: true,
                  sidebarDepth: 1
                },
                {
                  title: 'Animation.translate',
                  path: '/api/ui/animation/Animation.translate.md',
                  collapsable: true,
                  sidebarDepth: 1
                },
                {
                  title: 'Animation.translate3d',
                  path: '/api/ui/animation/Animation.translate3d.md',
                  collapsable: true,
                  sidebarDepth: 1
                },
                {
                  title: 'Animation.translateX',
                  path: '/api/ui/animation/Animation.translateX.md',
                  collapsable: true,
                  sidebarDepth: 1
                },
                {
                  title: 'Animation.translateY',
                  path: '/api/ui/animation/Animation.translateY.md',
                  collapsable: true,
                  sidebarDepth: 1
                },
                {
                  title: 'Animation.translateZ',
                  path: '/api/ui/animation/Animation.translateZ.md',
                  collapsable: true,
                  sidebarDepth: 1
                },
                {
                  title: 'Animation.width',
                  path: '/api/ui/animation/Animation.width.md',
                  collapsable: true,
                  sidebarDepth: 1
                }
              ]
            },
            {
              title: 'background',
              collapsable: true,
              sidebarDepth: 1,
              children: [
                {
                  title: 'qa.setBackgroundColor',
                  path: '/api/ui/background/qa.setBackgroundColor.md',
                  collapsable: true,
                  sidebarDepth: 1
                },
                {
                  title: 'qa.setBackgroundTextStyle',
                  path: '/api/ui/background/qa.setBackgroundTextStyle.md',
                  collapsable: true,
                  sidebarDepth: 1
                }
              ]
            },
            {
              title: 'custom-component',
              collapsable: true,
              sidebarDepth: 1,
              children: [
                {
                  title: 'qa.nextTick',
                  path: '/api/ui/custom-component/qa.nextTick.md',
                  collapsable: true,
                  sidebarDepth: 1
                }
              ]
            },
            {
              title: 'font',
              collapsable: true,
              sidebarDepth: 1,
              children: [
                {
                  title: 'qa.loadFontFace',
                  path: '/api/ui/font/qa.loadFontFace.md',
                  collapsable: true,
                  sidebarDepth: 1
                }
              ]
            },
            {
              title: 'interaction',
              collapsable: true,
              sidebarDepth: 1,
              children: [
                {
                  title: 'qa.hideLoading',
                  path: '/api/ui/interaction/qa.hideLoading.md',
                  collapsable: true,
                  sidebarDepth: 1
                },
                {
                  title: 'qa.hideToast',
                  path: '/api/ui/interaction/qa.hideToast.md',
                  collapsable: true,
                  sidebarDepth: 1
                },
                {
                  title: 'qa.showActionSheet',
                  path: '/api/ui/interaction/qa.showActionSheet.md',
                  collapsable: true,
                  sidebarDepth: 1
                },
                {
                  title: 'qa.showLoading',
                  path: '/api/ui/interaction/qa.showLoading.md',
                  collapsable: true,
                  sidebarDepth: 1
                },
                {
                  title: 'qa.showModal',
                  path: '/api/ui/interaction/qa.showModal.md',
                  collapsable: true,
                  sidebarDepth: 1
                },
                {
                  title: 'qa.showToast',
                  path: '/api/ui/interaction/qa.showToast.md',
                  collapsable: true,
                  sidebarDepth: 1
                }
              ]
            },
            {
              title: 'menu',
              collapsable: true,
              sidebarDepth: 1,
              children: [
                {
                  title: 'qa.getMenuButtonBoundingClientRect',
                  path: '/api/ui/menu/qa.getMenuButtonBoundingClientRect.md',
                  collapsable: true,
                  sidebarDepth: 1
                }
              ]
            },
            {
              title: 'navigation-bar',
              collapsable: true,
              sidebarDepth: 1,
              children: [
                {
                  title: 'qa.hideNavigationBarLoading',
                  path: '/api/ui/navigation-bar/qa.hideNavigationBarLoading.md',
                  collapsable: true,
                  sidebarDepth: 1
                },
                {
                  title: 'qa.setNavigationBarColor',
                  path: '/api/ui/navigation-bar/qa.setNavigationBarColor.md',
                  collapsable: true,
                  sidebarDepth: 1
                },
                {
                  title: 'qa.setNavigationBarTitle',
                  path: '/api/ui/navigation-bar/qa.setNavigationBarTitle.md',
                  collapsable: true,
                  sidebarDepth: 1
                },
                {
                  title: 'qa.showNavigationBarLoading',
                  path: '/api/ui/navigation-bar/qa.showNavigationBarLoading.md',
                  collapsable: true,
                  sidebarDepth: 1
                }
              ]
            },
            {
              title: 'pull-down-refresh',
              collapsable: true,
              sidebarDepth: 1,
              children: [
                {
                  title: 'qa.startPullDownRefresh',
                  path: '/api/ui/pull-down-refresh/qa.startPullDownRefresh.md',
                  collapsable: true,
                  sidebarDepth: 1
                },
                {
                  title: 'qa.stopPullDownRefresh',
                  path: '/api/ui/pull-down-refresh/qa.stopPullDownRefresh.md',
                  collapsable: true,
                  sidebarDepth: 1
                }
              ]
            },
            {
              title: 'scroll',
              collapsable: true,
              sidebarDepth: 1,
              children: [
                {
                  title: 'qa.pageScrollTo',
                  path: '/api/ui/scroll/qa.pageScrollTo.md',
                  collapsable: true,
                  sidebarDepth: 1
                }
              ]
            },
            {
              title: 'tab-bar',
              collapsable: true,
              sidebarDepth: 1,
              children: [
                {
                  title: 'qa.hideTabBar',
                  path: '/api/ui/tab-bar/qa.hideTabBar.md',
                  collapsable: true,
                  sidebarDepth: 1
                },
                {
                  title: 'qa.hideTabBarRedDot',
                  path: '/api/ui/tab-bar/qa.hideTabBarRedDot.md',
                  collapsable: true,
                  sidebarDepth: 1
                },
                {
                  title: 'qa.removeTabBarBadge',
                  path: '/api/ui/tab-bar/qa.removeTabBarBadge.md',
                  collapsable: true,
                  sidebarDepth: 1
                },
                {
                  title: 'qa.setTabBarBadge',
                  path: '/api/ui/tab-bar/qa.setTabBarBadge.md',
                  collapsable: true,
                  sidebarDepth: 1
                },
                {
                  title: 'qa.setTabBarItem',
                  path: '/api/ui/tab-bar/qa.setTabBarItem.md',
                  collapsable: true,
                  sidebarDepth: 1
                },
                {
                  title: 'qa.setTabBarStyle',
                  path: '/api/ui/tab-bar/qa.setTabBarStyle.md',
                  collapsable: true,
                  sidebarDepth: 1
                },
                {
                  title: 'qa.showTabBar',
                  path: '/api/ui/tab-bar/qa.showTabBar.md',
                  collapsable: true,
                  sidebarDepth: 1
                },
                {
                  title: 'qa.showTabBarRedDot',
                  path: '/api/ui/tab-bar/qa.showTabBarRedDot.md',
                  collapsable: true,
                  sidebarDepth: 1
                }
              ]
            }
          ]
        },
        {
          title: '网络', // required
          collapsable: true, // optional, defaults to true
          sidebarDepth: 1, // optional, defaults to 1
          children: [
            {
              title: 'download',
              collapsable: true,
              sidebarDepth: 1,
              children: [
                {
                  title: 'qa.downloadFile',
                  path: '/api/network/download/qa.downloadFile.md',
                  collapsable: true,
                  sidebarDepth: 1
                },
                {
                  title: 'DownloadTask',
                  collapsable: true,
                  sidebarDepth: 1,
                  children: [
                    {
                      title: 'DownloadTask',
                      path: '/api/network/download/DownloadTask.md',
                      collapsable: true,
                      sidebarDepth: 1
                    },
                    {
                      title: 'DownloadTask.abort',
                      path: '/api/network/download/DownloadTask.abort.md',
                      collapsable: true,
                      sidebarDepth: 1
                    },
                    {
                      title: 'DownloadTask.offProgressUpdate',
                      path: '/api/network/download/DownloadTask.offProgressUpdate.md',
                      collapsable: true,
                      sidebarDepth: 1
                    },
                    {
                      title: 'DownloadTask.onProgressUpdate',
                      path: '/api/network/download/DownloadTask.onProgressUpdate.md',
                      collapsable: true,
                      sidebarDepth: 1
                    }
                  ]
                }
              ]
            },
            {
              title: 'request',
              collapsable: true,
              sidebarDepth: 1,
              children: [
                {
                  title: 'qa.request',
                  path: '/api/network/request/qa.request.md',
                  collapsable: true,
                  sidebarDepth: 1
                },
                {
                  title: 'RequestTask',
                  collapsable: true,
                  sidebarDepth: 1,
                  children: [
                    {
                      title: 'RequestTask',
                      path: '/api/network/request/RequestTask.md',
                      collapsable: true,
                      sidebarDepth: 1
                    },
                    {
                      title: 'RequestTask.abort',
                      path: '/api/network/request/RequestTask.abort.md',
                      collapsable: true,
                      sidebarDepth: 1
                    }
                  ]
                }
              ]
            },
            {
              title: 'upload',
              collapsable: true,
              sidebarDepth: 1,
              children: [
                {
                  title: 'qa.uploadFile',
                  path: '/api/network/upload/qa.uploadFile.md',
                  collapsable: true,
                  sidebarDepth: 1
                },
                {
                  title: 'UploadTask',
                  collapsable: true,
                  sidebarDepth: 1,
                  children: [
                    {
                      title: 'UploadTask',
                      path: '/api/network/upload/UploadTask.md',
                      collapsable: true,
                      sidebarDepth: 1
                    },
                    {
                      title: 'UploadTask.abort',
                      path: '/api/network/upload/UploadTask.abort.md',
                      collapsable: true,
                      sidebarDepth: 1
                    },
                    {
                      title: 'UploadTask.offProgressUpdate',
                      path: '/api/network/upload/UploadTask.offProgressUpdate.md',
                      collapsable: true,
                      sidebarDepth: 1
                    },
                    {
                      title: 'UploadTask.onProgressUpdate',
                      path: '/api/network/upload/UploadTask.onProgressUpdate.md',
                      collapsable: true,
                      sidebarDepth: 1
                    }
                  ]
                }
              ]
            },
            {
              title: 'websocket',
              collapsable: true,
              sidebarDepth: 1,
              children: [
                {
                  title: 'qa.closeSocket',
                  path: '/api/network/websocket/qa.closeSocket.md',
                  collapsable: true,
                  sidebarDepth: 1
                },

                {
                  title: 'qa.onSocketClose',
                  path: '/api/network/websocket/qa.onSocketClose.md',
                  collapsable: true,
                  sidebarDepth: 1
                },
                {
                  title: 'qa.onSocketError',
                  path: '/api/network/websocket/qa.onSocketError.md',
                  collapsable: true,
                  sidebarDepth: 1
                },
                {
                  title: 'qa.onSocketMessage',
                  path: '/api/network/websocket/qa.onSocketMessage.md',
                  collapsable: true,
                  sidebarDepth: 1
                },
                {
                  title: 'qa.onSocketOpen',
                  path: '/api/network/websocket/qa.onSocketOpen.md',
                  collapsable: true,
                  sidebarDepth: 1
                },
                {
                  title: 'qa.sendSocketMessage',
                  path: '/api/network/websocket/qa.sendSocketMessage.md',
                  collapsable: true,
                  sidebarDepth: 1
                },
                {
                  title: 'qa.connectSocket',
                  path: '/api/network/websocket/qa.connectSocket.md',
                  collapsable: true,
                  sidebarDepth: 1
                },
                {
                  title: 'SocketTask',
                  collapsable: true,
                  sidebarDepth: 1,
                  children: [
                    {
                      title: 'SocketTask',
                      path: '/api/network/websocket/SocketTask.md',
                      collapsable: true,
                      sidebarDepth: 1
                    },
                    {
                      title: 'SocketTask.close',
                      path: '/api/network/websocket/SocketTask.close.md',
                      collapsable: true,
                      sidebarDepth: 1
                    },
                    {
                      title: 'SocketTask.onClose',
                      path: '/api/network/websocket/SocketTask.onClose.md',
                      collapsable: true,
                      sidebarDepth: 1
                    },
                    {
                      title: 'SocketTask.onError',
                      path: '/api/network/websocket/SocketTask.onError.md',
                      collapsable: true,
                      sidebarDepth: 1
                    },
                    {
                      title: 'SocketTask.onMessage',
                      path: '/api/network/websocket/SocketTask.onMessage.md',
                      collapsable: true,
                      sidebarDepth: 1
                    },
                    {
                      title: 'SocketTask.onOpen',
                      path: '/api/network/websocket/SocketTask.onOpen.md',
                      collapsable: true,
                      sidebarDepth: 1
                    },
                    {
                      title: 'SocketTask.send',
                      path: '/api/network/websocket/SocketTask.send.md',
                      collapsable: true,
                      sidebarDepth: 1
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          title: '数据缓存', // required
          collapsable: true, // optional, defaults to true
          sidebarDepth: 1, // optional, defaults to 1
          children: [
            {
              title: 'qa.clearStorage',
              path: '/api/storage/qa.clearStorage.md',
              collapsable: true,
              sidebarDepth: 1
            },
            {
              title: 'qa.clearStorageSync',
              path: '/api/storage/qa.clearStorageSync.md',
              collapsable: true,
              sidebarDepth: 1
            },
            {
              title: 'qa.getStorage',
              path: '/api/storage/qa.getStorage.md',
              collapsable: true,
              sidebarDepth: 1
            },
            {
              title: 'qa.getStorageInfo',
              path: '/api/storage/qa.getStorageInfo.md',
              collapsable: true,
              sidebarDepth: 1
            },
            {
              title: 'qa.getStorageInfoSync',
              path: '/api/storage/qa.getStorageInfoSync.md',
              collapsable: true,
              sidebarDepth: 1
            },
            {
              title: 'qa.getStorageSync',
              path: '/api/storage/qa.getStorageSync.md',
              collapsable: true,
              sidebarDepth: 1
            },
            {
              title: 'qa.removeStorage',
              path: '/api/storage/qa.removeStorage.md',
              collapsable: true,
              sidebarDepth: 1
            },
            {
              title: 'qa.removeStorageSync',
              path: '/api/storage/qa.removeStorageSync.md',
              collapsable: true,
              sidebarDepth: 1
            },
            {
              title: 'qa.setStorage',
              path: '/api/storage/qa.setStorage.md',
              collapsable: true,
              sidebarDepth: 1
            },
            {
              title: 'qa.setStorageSync',
              path: '/api/storage/qa.setStorageSync.md',
              collapsable: true,
              sidebarDepth: 1
            }
          ]
        },

        {
          title: '媒体', // required
          collapsable: true, // optional, defaults to true
          sidebarDepth: 1, // optional, defaults to 1
          children: [
            {
              title: 'audio',
              collapsable: true,
              sidebarDepth: 1,
              children: [
                {
                  title: 'qa.setInnerAudioOption',
                  path: '/api/media/audio/qa.setInnerAudioOption.md',
                  collapsable: true,
                  sidebarDepth: 1
                },
                {
                  title: 'qa.createInnerAudioContext',
                  path: '/api/media/audio/qa.createInnerAudioContext.md',
                  collapsable: true,
                  sidebarDepth: 1
                },

                {
                  title: 'InnerAudioContext',
                  collapsable: true,
                  sidebarDepth: 1,
                  children: [
                    {
                      title: 'InnerAudioContext',
                      path: '/api/media/audio/InnerAudioContext.md',
                      collapsable: true,
                      sidebarDepth: 1
                    },
                    {
                      title: 'InnerAudioContext.destroy',
                      path: '/api/media/audio/InnerAudioContext.destroy.md',
                      collapsable: true,
                      sidebarDepth: 1
                    },
                    {
                      title: 'InnerAudioContext.offCanplay',
                      path: '/api/media/audio/InnerAudioContext.offCanplay.md',
                      collapsable: true,
                      sidebarDepth: 1
                    },
                    {
                      title: 'InnerAudioContext.offEnded',
                      path: '/api/media/audio/InnerAudioContext.offEnded.md',
                      collapsable: true,
                      sidebarDepth: 1
                    },
                    {
                      title: 'InnerAudioContext.offError',
                      path: '/api/media/audio/InnerAudioContext.offError.md',
                      collapsable: true,
                      sidebarDepth: 1
                    },
                    {
                      title: 'InnerAudioContext.offPause',
                      path: '/api/media/audio/InnerAudioContext.offPause.md',
                      collapsable: true,
                      sidebarDepth: 1
                    },
                    {
                      title: 'InnerAudioContext.offPlay',
                      path: '/api/media/audio/InnerAudioContext.offPlay.md',
                      collapsable: true,
                      sidebarDepth: 1
                    },
                    {
                      title: 'InnerAudioContext.offSeeked',
                      path: '/api/media/audio/InnerAudioContext.offSeeked.md',
                      collapsable: true,
                      sidebarDepth: 1
                    },
                    {
                      title: 'InnerAudioContext.offSeeking',
                      path: '/api/media/audio/InnerAudioContext.offSeeking.md',
                      collapsable: true,
                      sidebarDepth: 1
                    },
                    {
                      title: 'InnerAudioContext.offStop',
                      path: '/api/media/audio/InnerAudioContext.offStop.md',
                      collapsable: true,
                      sidebarDepth: 1
                    },
                    {
                      title: 'InnerAudioContext.offTimeUpdate',
                      path: '/api/media/audio/InnerAudioContext.offTimeUpdate.md',
                      collapsable: true,
                      sidebarDepth: 1
                    },
                    {
                      title: 'InnerAudioContext.offWaiting',
                      path: '/api/media/audio/InnerAudioContext.offWaiting.md',
                      collapsable: true,
                      sidebarDepth: 1
                    },
                    {
                      title: 'InnerAudioContext.onCanplay',
                      path: '/api/media/audio/InnerAudioContext.onCanplay.md',
                      collapsable: true,
                      sidebarDepth: 1
                    },
                    {
                      title: 'InnerAudioContext.onEnded',
                      path: '/api/media/audio/InnerAudioContext.onEnded.md',
                      collapsable: true,
                      sidebarDepth: 1
                    },
                    {
                      title: 'InnerAudioContext.onError',
                      path: '/api/media/audio/InnerAudioContext.onError.md',
                      collapsable: true,
                      sidebarDepth: 1
                    },
                    {
                      title: 'InnerAudioContext.onPause',
                      path: '/api/media/audio/InnerAudioContext.onPause.md',
                      collapsable: true,
                      sidebarDepth: 1
                    },
                    {
                      title: 'InnerAudioContext.onPlay',
                      path: '/api/media/audio/InnerAudioContext.onPlay.md',
                      collapsable: true,
                      sidebarDepth: 1
                    },
                    {
                      title: 'InnerAudioContext.onSeeked',
                      path: '/api/media/audio/InnerAudioContext.onSeeked.md',
                      collapsable: true,
                      sidebarDepth: 1
                    },
                    {
                      title: 'InnerAudioContext.onSeeking',
                      path: '/api/media/audio/InnerAudioContext.onSeeking.md',
                      collapsable: true,
                      sidebarDepth: 1
                    },
                    {
                      title: 'InnerAudioContext.onStop',
                      path: '/api/media/audio/InnerAudioContext.onStop.md',
                      collapsable: true,
                      sidebarDepth: 1
                    },
                    {
                      title: 'InnerAudioContext.onTimeUpdate',
                      path: '/api/media/audio/InnerAudioContext.onTimeUpdate.md',
                      collapsable: true,
                      sidebarDepth: 1
                    },
                    {
                      title: 'InnerAudioContext.onWaiting',
                      path: '/api/media/audio/InnerAudioContext.onWaiting.md',
                      collapsable: true,
                      sidebarDepth: 1
                    },
                    {
                      title: 'InnerAudioContext.pause',
                      path: '/api/media/audio/InnerAudioContext.pause.md',
                      collapsable: true,
                      sidebarDepth: 1
                    },
                    {
                      title: 'InnerAudioContext.play',
                      path: '/api/media/audio/InnerAudioContext.play.md',
                      collapsable: true,
                      sidebarDepth: 1
                    },
                    {
                      title: 'InnerAudioContext.seek',
                      path: '/api/media/audio/InnerAudioContext.seek.md',
                      collapsable: true,
                      sidebarDepth: 1
                    },
                    {
                      title: 'InnerAudioContext.stop',
                      path: '/api/media/audio/InnerAudioContext.stop.md',
                      collapsable: true,
                      sidebarDepth: 1
                    }
                  ]
                }
              ]
            },
            {
              title: 'map',
              collapsable: true,
              sidebarDepth: 1,
              children: [
                {
                  title: 'qa.createMapContext',
                  path: '/api/media/map/qa.createMapContext.md',
                  collapsable: true,
                  sidebarDepth: 1
                },
                {
                  title: 'MapContext',
                  collapsable: true,
                  sidebarDepth: 1,
                  children: [
                    {
                      title: 'MapContext',
                      path: '/api/media/map/MapContext.md',
                      collapsable: true,
                      sidebarDepth: 1
                    },
                    {
                      title: 'MapContext.getCenterLocation',
                      path: '/api/media/map/MapContext.getCenterLocation.md',
                      collapsable: true,
                      sidebarDepth: 1
                    },
                    {
                      title: 'MapContext.getRegion',
                      path: '/api/media/map/MapContext.getRegion.md',
                      collapsable: true,
                      sidebarDepth: 1
                    },
                    {
                      title: 'MapContext.getScale',
                      path: '/api/media/map/MapContext.getScale.md',
                      collapsable: true,
                      sidebarDepth: 1
                    },
                    {
                      title: 'MapContext.includePoints',
                      path: '/api/media/map/MapContext.includePoints.md',
                      collapsable: true,
                      sidebarDepth: 1
                    },

                    {
                      title: 'MapContext.moveToLocation',
                      path: '/api/media/map/MapContext.moveToLocation.md',
                      collapsable: true,
                      sidebarDepth: 1
                    },
                    {
                      title: 'MapContext.translateMarker',
                      path: '/api/media/map/MapContext.translateMarker.md',
                      collapsable: true,
                      sidebarDepth: 1
                    }
                  ]
                }
              ]
            },
            {
              title: 'image',
              collapsable: true,
              sidebarDepth: 1,
              children: [
                {
                  title: 'qa.chooseImage',
                  path: '/api/media/image/qa.chooseImage.md',
                  collapsable: true,
                  sidebarDepth: 1
                },
                {
                  title: 'qa.compressImage',
                  path: '/api/media/image/qa.compressImage.md',
                  collapsable: true,
                  sidebarDepth: 1
                },
                {
                  title: 'qa.getImageInfo',
                  path: '/api/media/image/qa.getImageInfo.md',
                  collapsable: true,
                  sidebarDepth: 1
                },
                {
                  title: 'qa.previewImage',
                  path: '/api/media/image/qa.previewImage.md',
                  collapsable: true,
                  sidebarDepth: 1
                },
                {
                  title: 'qa.saveImageToPhotosAlbum',
                  path: '/api/media/image/qa.saveImageToPhotosAlbum.md',
                  collapsable: true,
                  sidebarDepth: 1
                }
              ]
            },
            {
              title: 'recorder',
              collapsable: true,
              sidebarDepth: 1,
              children: [
                {
                  title: 'qa.startRecord',
                  path: '/api/media/recorder/qa.startRecord.md',
                  collapsable: true,
                  sidebarDepth: 1
                },
                {
                  title: 'qa.stopRecord',
                  path: '/api/media/recorder/qa.stopRecord.md',
                  collapsable: true,
                  sidebarDepth: 1
                },
                {
                  title: 'qa.getRecorderManager',
                  path: '/api/media/recorder/qa.getRecorderManager.md',
                  collapsable: true,
                  sidebarDepth: 1
                },
                {
                  title: 'RecorderManager',
                  collapsable: true,
                  sidebarDepth: 1,
                  children: [
                    {
                      title: 'RecorderManager',
                      path: '/api/media/recorder/RecorderManager.md',
                      collapsable: true,
                      sidebarDepth: 1
                    },
                    {
                      title: 'RecorderManager.onError',
                      path: '/api/media/recorder/RecorderManager.onError.md',
                      collapsable: true,
                      sidebarDepth: 1
                    },
                    {
                      title: 'RecorderManager.onPause',
                      path: '/api/media/recorder/RecorderManager.onPause.md',
                      collapsable: true,
                      sidebarDepth: 1
                    },
                    {
                      title: 'RecorderManager.onResume',
                      path: '/api/media/recorder/RecorderManager.onResume.md',
                      collapsable: true,
                      sidebarDepth: 1
                    },
                    {
                      title: 'RecorderManager.onStart',
                      path: '/api/media/recorder/RecorderManager.onStart.md',
                      collapsable: true,
                      sidebarDepth: 1
                    },
                    {
                      title: 'RecorderManager.onStop',
                      path: '/api/media/recorder/RecorderManager.onStop.md',
                      collapsable: true,
                      sidebarDepth: 1
                    },
                    {
                      title: 'RecorderManager.pause',
                      path: '/api/media/recorder/RecorderManager.pause.md',
                      collapsable: true,
                      sidebarDepth: 1
                    },
                    {
                      title: 'RecorderManager.resume',
                      path: '/api/media/recorder/RecorderManager.resume.md',
                      collapsable: true,
                      sidebarDepth: 1
                    },
                    {
                      title: 'RecorderManager.start',
                      path: '/api/media/recorder/RecorderManager.start.md',
                      collapsable: true,
                      sidebarDepth: 1
                    },
                    {
                      title: 'RecorderManager.stop',
                      path: '/api/media/recorder/RecorderManager.stop.md',
                      collapsable: true,
                      sidebarDepth: 1
                    }
                  ]
                }
              ]
            },
            {
              title: 'background-audio',
              collapsable: true,
              sidebarDepth: 1,
              children: [
                {
                  title: 'qa.onBackgroundAudioPause',
                  path: '/api/media/background-audio/qa.onBackgroundAudioPause.md',
                  collapsable: true,
                  sidebarDepth: 1
                },
                {
                  title: 'qa.onBackgroundAudioPlay',
                  path: '/api/media/background-audio/qa.onBackgroundAudioPlay.md',
                  collapsable: true,
                  sidebarDepth: 1
                },
                {
                  title: 'qa.onBackgroundAudioStop',
                  path: '/api/media/background-audio/qa.onBackgroundAudioStop.md',
                  collapsable: true,
                  sidebarDepth: 1
                },
                {
                  title: 'qa.pauseBackgroundAudio',
                  path: '/api/media/background-audio/qa.pauseBackgroundAudio.md',
                  collapsable: true,
                  sidebarDepth: 1
                },
                {
                  title: 'qa.playBackgroundAudio',
                  path: '/api/media/background-audio/qa.playBackgroundAudio.md',
                  collapsable: true,
                  sidebarDepth: 1
                },
                {
                  title: 'qa.seekBackgroundAudio',
                  path: '/api/media/background-audio/qa.seekBackgroundAudio.md',
                  collapsable: true,
                  sidebarDepth: 1
                },
                {
                  title: 'qa.stopBackgroundAudio',
                  path: '/api/media/background-audio/qa.stopBackgroundAudio.md',
                  collapsable: true,
                  sidebarDepth: 1
                },
                {
                  title: 'qa.getBackgroundAudioPlayerState',
                  path: '/api/media/background-audio/qa.getBackgroundAudioPlayerState.md',
                  collapsable: true,
                  sidebarDepth: 1
                },
                {
                  title: 'qa.getBackgroundAudioManager',
                  path: '/api/media/background-audio/qa.getBackgroundAudioManager.md',
                  collapsable: true,
                  sidebarDepth: 1
                },
                {
                  title: 'BackgroundAudioManager',
                  collapsable: true,
                  sidebarDepth: 1,
                  children: [
                    {
                      title: 'BackgroundAudioManager',
                      path: '/api/media/background-audio/BackgroundAudioManager.md',
                      collapsable: true,
                      sidebarDepth: 1
                    },
                    {
                      title: 'BackgroundAudioManager.onCanplay',
                      path: '/api/media/background-audio/BackgroundAudioManager.onCanplay.md',
                      collapsable: true,
                      sidebarDepth: 1
                    },
                    {
                      title: 'BackgroundAudioManager.onEnded',
                      path: '/api/media/background-audio/BackgroundAudioManager.onEnded.md',
                      collapsable: true,
                      sidebarDepth: 1
                    },
                    {
                      title: 'BackgroundAudioManager.onError',
                      path: '/api/media/background-audio/BackgroundAudioManager.onError.md',
                      collapsable: true,
                      sidebarDepth: 1
                    },
                    {
                      title: 'BackgroundAudioManager.onPause',
                      path: '/api/media/background-audio/BackgroundAudioManager.onPause.md',
                      collapsable: true,
                      sidebarDepth: 1
                    },
                    {
                      title: 'BackgroundAudioManager.onPlay',
                      path: '/api/media/background-audio/BackgroundAudioManager.onPlay.md',
                      collapsable: true,
                      sidebarDepth: 1
                    },
                    {
                      title: 'BackgroundAudioManager.onSeeked',
                      path: '/api/media/background-audio/BackgroundAudioManager.onSeeked.md',
                      collapsable: true,
                      sidebarDepth: 1
                    },
                    {
                      title: 'BackgroundAudioManager.onSeeking',
                      path: '/api/media/background-audio/BackgroundAudioManager.onSeeking.md',
                      collapsable: true,
                      sidebarDepth: 1
                    },
                    {
                      title: 'BackgroundAudioManager.onStop',
                      path: '/api/media/background-audio/BackgroundAudioManager.onStop.md',
                      collapsable: true,
                      sidebarDepth: 1
                    },
                    {
                      title: 'BackgroundAudioManager.onTimeUpdate',
                      path: '/api/media/background-audio/BackgroundAudioManager.onTimeUpdate.md',
                      collapsable: true,
                      sidebarDepth: 1
                    },
                    {
                      title: 'BackgroundAudioManager.onWaiting',
                      path: '/api/media/background-audio/BackgroundAudioManager.onWaiting.md',
                      collapsable: true,
                      sidebarDepth: 1
                    },
                    {
                      title: 'BackgroundAudioManager.pause',
                      path: '/api/media/background-audio/BackgroundAudioManager.pause.md',
                      collapsable: true,
                      sidebarDepth: 1
                    },
                    {
                      title: 'BackgroundAudioManager.play',
                      path: '/api/media/background-audio/BackgroundAudioManager.play.md',
                      collapsable: true,
                      sidebarDepth: 1
                    },
                    {
                      title: 'BackgroundAudioManager.seek',
                      path: '/api/media/background-audio/BackgroundAudioManager.seek.md',
                      collapsable: true,
                      sidebarDepth: 1
                    },
                    {
                      title: 'BackgroundAudioManager.stop',
                      path: '/api/media/background-audio/BackgroundAudioManager.stop.md',
                      collapsable: true,
                      sidebarDepth: 1
                    }
                  ]
                }
              ]
            },
            {
              title: 'video',
              collapsable: true,
              sidebarDepth: 1,
              children: [
                {
                  title: 'qa.chooseVideo',
                  path: '/api/media/video/qa.chooseVideo.md',
                  collapsable: true,
                  sidebarDepth: 1
                },
                {
                  title: 'qa.saveVideoToPhotosAlbum',
                  path: '/api/media/video/qa.saveVideoToPhotosAlbum.md',
                  collapsable: true,
                  sidebarDepth: 1
                },
                {
                  title: 'qa.createVideoContext',
                  path: '/api/media/video/qa.createVideoContext.md',
                  collapsable: true,
                  sidebarDepth: 1
                },
                {
                  title: 'VideoContext',
                  collapsable: true,
                  sidebarDepth: 1,
                  children: [
                    {
                      title: 'VideoContext',
                      path: '/api/media/video/VideoContext.md',
                      collapsable: true,
                      sidebarDepth: 1
                    },
                    {
                      title: 'VideoContext.exitFullScreen',
                      path: '/api/media/video/VideoContext.exitFullScreen.md',
                      collapsable: true,
                      sidebarDepth: 1
                    },

                    {
                      title: 'VideoContext.pause',
                      path: '/api/media/video/VideoContext.pause.md',
                      collapsable: true,
                      sidebarDepth: 1
                    },
                    {
                      title: 'VideoContext.play',
                      path: '/api/media/video/VideoContext.play.md',
                      collapsable: true,
                      sidebarDepth: 1
                    },
                    {
                      title: 'VideoContext.requestFullScreen',
                      path: '/api/media/video/VideoContext.requestFullScreen.md',
                      collapsable: true,
                      sidebarDepth: 1
                    },
                    {
                      title: 'VideoContext.seek',
                      path: '/api/media/video/VideoContext.seek.md',
                      collapsable: true,
                      sidebarDepth: 1
                    },
                    {
                      title: 'VideoContext.stop',
                      path: '/api/media/video/VideoContext.stop.md',
                      collapsable: true,
                      sidebarDepth: 1
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          title: '位置', // required
          collapsable: true, // optional, defaults to true
          sidebarDepth: 1, // optional, defaults to 1
          children: [
            {
              title: 'qa.chooseLocation',
              path: '/api/location/qa.chooseLocation.md',
              collapsable: true,
              sidebarDepth: 1
            },
            {
              title: 'qa.getLocation',
              path: '/api/location/qa.getLocation.md',
              collapsable: true,
              sidebarDepth: 1
            },
            {
              title: 'qa.openLocation',
              path: '/api/location/qa.openLocation.md',
              collapsable: true,
              sidebarDepth: 1
            }
          ]
        },
        {
          title: '转发', // required
          collapsable: true, // optional, defaults to true
          sidebarDepth: 1, // optional, defaults to 1
          children: []
        },
        {
          title: '文件', // required
          collapsable: true, // optional, defaults to true
          sidebarDepth: 1, // optional, defaults to 1
          children: [
            {
              title: 'qa.getFileInfo',
              path: '/api/file/qa.getFileInfo.md',
              collapsable: true,
              sidebarDepth: 1
            },
            {
              title: 'qa.getSavedFileInfo',
              path: '/api/file/qa.getSavedFileInfo.md',
              collapsable: true,
              sidebarDepth: 1
            },
            {
              title: 'qa.getSavedFileList',
              path: '/api/file/qa.getSavedFileList.md',
              collapsable: true,
              sidebarDepth: 1
            },
            {
              title: 'qa.openDocument',
              path: '/api/file/qa.openDocument.md',
              collapsable: true,
              sidebarDepth: 1
            },
            {
              title: 'qa.removeSavedFile',
              path: '/api/file/qa.removeSavedFile.md',
              collapsable: true,
              sidebarDepth: 1
            },
            {
              title: 'qa.saveFile',
              path: '/api/file/qa.saveFile.md',
              collapsable: true,
              sidebarDepth: 1
            }
          ]
        },
        {
          title: '开放接口', // required
          collapsable: true, // optional, defaults to true
          sidebarDepth: 1, // optional, defaults to 1
          children: [
            {
              title: 'alipay',
              collapsable: true,
              sidebarDepth: 1,
              children: [
                {
                  title: 'qa.requestAliPayment',
                  path: '/api/open-api/alipay/qa.requestAliPayment.md',
                  collapsable: true,
                  sidebarDepth: 1
                }
              ]
            },
            {
              title: 'authorize',
              collapsable: true,
              sidebarDepth: 1,
              children: [
                {
                  title: 'qa.authorize',
                  path: '/api/open-api/authorize/qa.authorize.md',
                  collapsable: true,
                  sidebarDepth: 1
                }
              ]
            },
            {
              title: 'login',
              collapsable: true,
              sidebarDepth: 1,
              children: [
                {
                  title: 'qa.login',
                  path: '/api/open-api/login/qa.login.md',
                  collapsable: true,
                  sidebarDepth: 1
                }
              ]
            },
            {
              title: 'quickapp-navigate',
              collapsable: true,
              sidebarDepth: 1,
              children: [
                {
                  title: 'qa.navigateBackQuickapp',
                  path: '/api/open-api/quickapp-navigate/qa.navigateBackQuickapp.md',
                  collapsable: true,
                  sidebarDepth: 1
                },
                {
                  title: 'qa.navigateToQuickapp',
                  path: '/api/open-api/quickapp-navigate/qa.navigateToQuickapp.md',
                  collapsable: true,
                  sidebarDepth: 1
                }
              ]
            },
            {
              title: 'setting',
              collapsable: true,
              sidebarDepth: 1,
              children: [
                {
                  title: 'AuthSetting',
                  path: '/api/open-api/setting/AuthSetting.md',
                  collapsable: true,
                  sidebarDepth: 1
                },
                {
                  title: 'qa.getSetting',
                  path: '/api/open-api/setting/qa.getSetting.md',
                  collapsable: true,
                  sidebarDepth: 1
                }
              ]
            },
            {
              title: 'user-info',
              collapsable: true,
              sidebarDepth: 1,
              children: [
                {
                  title: 'qa.getUserInfo',
                  path: '/api/open-api/user-info/qa.getUserInfo.md',
                  collapsable: true,
                  sidebarDepth: 1
                }
              ]
            },
            {
              title: 'wxpay',
              collapsable: true,
              sidebarDepth: 1,
              children: [
                {
                  title: 'qa.getWxPaymentType',
                  path: '/api/open-api/wxpay/qa.getWxPaymentType.md',
                  collapsable: true,
                  sidebarDepth: 1
                },
                {
                  title: 'qa.requestWxPayment',
                  path: '/api/open-api/wxpay/qa.requestWxPayment.md',
                  collapsable: true,
                  sidebarDepth: 1
                }
              ]
            },
            {
              title: 'vendorpay',
              collapsable: true,
              sidebarDepth: 1,
              children: [
                {
                  title: 'qa.getVendorPaymentProvider',
                  path: '/api/open-api/vendorpay/qa.getVendorPaymentProvider.md',
                  collapsable: true,
                  sidebarDepth: 1
                },
                {
                  title: 'qa.requestVendorPayment',
                  path: '/api/open-api/vendorpay/qa.requestVendorPayment.md',
                  collapsable: true,
                  sidebarDepth: 1
                }
              ]
            }
          ]
        },
        {
          title: '设备', // required
          collapsable: true, // optional, defaults to true
          sidebarDepth: 1, // optional, defaults to 1
          children: [
            {
              title: 'accelerometer',
              collapsable: true,
              sidebarDepth: 1,
              children: [
                {
                  title: 'qa.onAccelerometerChange',
                  path: '/api/device/accelerometer/qa.onAccelerometerChange.md',
                  collapsable: true,
                  sidebarDepth: 1
                },
                {
                  title: 'qa.startAccelerometer',
                  path: '/api/device/accelerometer/qa.startAccelerometer.md',
                  collapsable: true,
                  sidebarDepth: 1
                },
                {
                  title: 'qa.stopAccelerometer',
                  path: '/api/device/accelerometer/qa.stopAccelerometer.md',
                  collapsable: true,
                  sidebarDepth: 1
                }
              ]
            },
            {
              title: 'battery',
              collapsable: true,
              sidebarDepth: 1,
              children: [
                {
                  title: 'qa.getBatteryInfo',
                  path: '/api/device/battery/qa.getBatteryInfo.md',
                  collapsable: true,
                  sidebarDepth: 1
                },
                {
                  title: 'qa.getBatteryInfoSync',
                  path: '/api/device/battery/qa.getBatteryInfoSync.md',
                  collapsable: true,
                  sidebarDepth: 1
                }
              ]
            },
            {
              title: 'bluetooth',
              collapsable: true,
              sidebarDepth: 1,
              children: [
                {
                  title: 'qa.closeBluetoothAdapter',
                  path: '/api/device/bluetooth/qa.closeBluetoothAdapter.md',
                  collapsable: true,
                  sidebarDepth: 1
                },
                {
                  title: 'qa.getBluetoothAdapterState',
                  path: '/api/device/bluetooth/qa.getBluetoothAdapterState.md',
                  collapsable: true,
                  sidebarDepth: 1
                },
                {
                  title: 'qa.getBluetoothDevices',
                  path: '/api/device/bluetooth/qa.getBluetoothDevices.md',
                  collapsable: true,
                  sidebarDepth: 1
                },
                {
                  title: 'qa.getConnectedBluetoothDevices',
                  path: '/api/device/bluetooth/qa.getConnectedBluetoothDevices.md',
                  collapsable: true,
                  sidebarDepth: 1
                },
                {
                  title: 'qa.onBluetoothAdapterStateChange',
                  path: '/api/device/bluetooth/qa.onBluetoothAdapterStateChange.md',
                  collapsable: true,
                  sidebarDepth: 1
                },
                {
                  title: 'qa.onBluetoothDeviceFound',
                  path: '/api/device/bluetooth/qa.onBluetoothDeviceFound.md',
                  collapsable: true,
                  sidebarDepth: 1
                },
                {
                  title: 'qa.openBluetoothAdapter',
                  path: '/api/device/bluetooth/qa.openBluetoothAdapter.md',
                  collapsable: true,
                  sidebarDepth: 1
                },
                {
                  title: 'qa.startBluetoothDevicesDiscovery',
                  path: '/api/device/bluetooth/qa.startBluetoothDevicesDiscovery.md',
                  collapsable: true,
                  sidebarDepth: 1
                },
                {
                  title: 'qa.stopBluetoothDevicesDiscovery',
                  path: '/api/device/bluetooth/qa.stopBluetoothDevicesDiscovery.md',
                  collapsable: true,
                  sidebarDepth: 1
                }
              ]
            },
            {
              title: 'clipboard',
              collapsable: true,
              sidebarDepth: 1,
              children: [
                {
                  title: 'qa.getClipboardData',
                  path: '/api/device/clipboard/qa.getClipboardData.md',
                  collapsable: true,
                  sidebarDepth: 1
                },
                {
                  title: 'qa.setClipboardData',
                  path: '/api/device/clipboard/qa.setClipboardData.md',
                  collapsable: true,
                  sidebarDepth: 1
                }
              ]
            },
            {
              title: 'bluetooth-ble',
              collapsable: true,
              sidebarDepth: 1,
              children: [
                {
                  title: 'qa.closeBLEConnection',
                  path: '/api/device/bluetooth-ble/qa.closeBLEConnection.md',
                  collapsable: true,
                  sidebarDepth: 1
                },
                {
                  title: 'qa.createBLEConnection',
                  path: '/api/device/bluetooth-ble/qa.createBLEConnection.md',
                  collapsable: true,
                  sidebarDepth: 1
                },
                {
                  title: 'qa.getBLEDeviceCharacteristics',
                  path: '/api/device/bluetooth-ble/qa.getBLEDeviceCharacteristics.md',
                  collapsable: true,
                  sidebarDepth: 1
                },
                {
                  title: 'qa.getBLEDeviceServices',
                  path: '/api/device/bluetooth-ble/qa.getBLEDeviceServices.md',
                  collapsable: true,
                  sidebarDepth: 1
                },
                {
                  title: 'qa.notifyBLECharacteristicValueChange',
                  path: '/api/device/bluetooth-ble/qa.notifyBLECharacteristicValueChange.md',
                  collapsable: true,
                  sidebarDepth: 1
                },
                {
                  title: 'qa.onBLECharacteristicValueChange',
                  path: '/api/device/bluetooth-ble/qa.onBLECharacteristicValueChange.md',
                  collapsable: true,
                  sidebarDepth: 1
                },
                {
                  title: 'qa.onBLEConnectionStateChange',
                  path: '/api/device/bluetooth-ble/qa.onBLEConnectionStateChange.md',
                  collapsable: true,
                  sidebarDepth: 1
                },
                {
                  title: 'qa.readBLECharacteristicValue',
                  path: '/api/device/bluetooth-ble/qa.readBLECharacteristicValue.md',
                  collapsable: true,
                  sidebarDepth: 1
                },
                {
                  title: 'qa.writeBLECharacteristicValue',
                  path: '/api/device/bluetooth-ble/qa.writeBLECharacteristicValue.md',
                  collapsable: true,
                  sidebarDepth: 1
                }
              ]
            },
            {
              title: 'contact',
              collapsable: true,
              sidebarDepth: 1,
              children: [
                {
                  title: 'qa.addPhoneContact',
                  path: '/api/device/contact/qa.addPhoneContact.md',
                  collapsable: true,
                  sidebarDepth: 1
                }
              ]
            },
            {
              title: 'compass',
              collapsable: true,
              sidebarDepth: 1,
              children: [
                {
                  title: 'qa.onCompassChange',
                  path: '/api/device/compass/qa.onCompassChange.md',
                  collapsable: true,
                  sidebarDepth: 1
                },
                {
                  title: 'qa.startCompass',
                  path: '/api/device/compass/qa.startCompass.md',
                  collapsable: true,
                  sidebarDepth: 1
                },
                {
                  title: 'qa.stopCompass',
                  path: '/api/device/compass/qa.stopCompass.md',
                  collapsable: true,
                  sidebarDepth: 1
                }
              ]
            },
            {
              title: 'gyroscope',
              collapsable: true,
              sidebarDepth: 1,
              children: [
                {
                  title: 'qa.onGyroscopeChange',
                  path: '/api/device/gyroscope/qa.onGyroscopeChange.md',
                  collapsable: true,
                  sidebarDepth: 1
                },
                {
                  title: 'qa.startGyroscope',
                  path: '/api/device/gyroscope/qa.startGyroscope.md',
                  collapsable: true,
                  sidebarDepth: 1
                },
                {
                  title: 'qa.stopGyroscope',
                  path: '/api/device/gyroscope/qa.stopGyroscope.md',
                  collapsable: true,
                  sidebarDepth: 1
                }
              ]
            },
            {
              title: 'motion',
              collapsable: true,
              sidebarDepth: 1,
              children: [
                {
                  title: 'qa.onDeviceMotionChange',
                  path: '/api/device/motion/qa.onDeviceMotionChange.md',
                  collapsable: true,
                  sidebarDepth: 1
                },
                {
                  title: 'qa.startDeviceMotionListening',
                  path: '/api/device/motion/qa.startDeviceMotionListening.md',
                  collapsable: true,
                  sidebarDepth: 1
                },
                {
                  title: 'qa.stopDeviceMotionListening',
                  path: '/api/device/motion/qa.stopDeviceMotionListening.md',
                  collapsable: true,
                  sidebarDepth: 1
                }
              ]
            },
            {
              title: 'network',
              collapsable: true,
              sidebarDepth: 1,
              children: [
                {
                  title: 'qa.getNetworkType',
                  path: '/api/device/network/qa.getNetworkType.md',
                  collapsable: true,
                  sidebarDepth: 1
                },
                {
                  title: 'qa.onNetworkStatusChange',
                  path: '/api/device/network/qa.onNetworkStatusChange.md',
                  collapsable: true,
                  sidebarDepth: 1
                }
              ]
            },
            {
              title: 'phone',
              collapsable: true,
              sidebarDepth: 1,
              children: [
                {
                  title: 'qa.makePhoneCall',
                  path: '/api/device/phone/qa.makePhoneCall.md',
                  collapsable: true,
                  sidebarDepth: 1
                }
              ]
            },
            {
              title: 'performance',
              collapsable: true,
              sidebarDepth: 1,
              children: [
                {
                  title: 'qa.onMemoryWarning',
                  path: '/api/device/performance/qa.onMemoryWarning.md',
                  collapsable: true,
                  sidebarDepth: 1
                }
              ]
            },
            {
              title: 'scan',
              collapsable: true,
              sidebarDepth: 1,
              children: [
                {
                  title: 'qa.scanCode',
                  path: '/api/device/scan/qa.scanCode.md',
                  collapsable: true,
                  sidebarDepth: 1
                }
              ]
            },
            {
              title: 'screen',
              collapsable: true,
              sidebarDepth: 1,
              children: [
                {
                  title: 'qa.getScreenBrightness',
                  path: '/api/device/screen/qa.getScreenBrightness.md',
                  collapsable: true,
                  sidebarDepth: 1
                },
                {
                  title: 'qa.onUserCaptureScreen',
                  path: '/api/device/screen/qa.onUserCaptureScreen.md',
                  collapsable: true,
                  sidebarDepth: 1
                },
                {
                  title: 'qa.setKeepScreenOn',
                  path: '/api/device/screen/qa.setKeepScreenOn.md',
                  collapsable: true,
                  sidebarDepth: 1
                },
                {
                  title: 'qa.setScreenBrightness',
                  path: '/api/device/screen/qa.setScreenBrightness.md',
                  collapsable: true,
                  sidebarDepth: 1
                }
              ]
            },
            {
              title: 'vibrate',
              collapsable: true,
              sidebarDepth: 1,
              children: [
                {
                  title: 'qa.vibrateLong',
                  path: '/api/device/vibrate/qa.vibrateLong.md',
                  collapsable: true,
                  sidebarDepth: 1
                },
                {
                  title: 'qa.vibrateShort',
                  path: '/api/device/vibrate/qa.vibrateShort.md',
                  collapsable: true,
                  sidebarDepth: 1
                }
              ]
            },
            {
              title: 'wifi',
              collapsable: true,
              sidebarDepth: 1,
              children: [
                {
                  title: 'WifiInfo',
                  path: '/api/device/wifi/WifiInfo.md',
                  collapsable: true,
                  sidebarDepth: 1
                },
                {
                  title: 'qa.connectWifi',
                  path: '/api/device/wifi/qa.connectWifi.md',
                  collapsable: true,
                  sidebarDepth: 1
                },
                {
                  title: 'qa.getConnectedWifi',
                  path: '/api/device/wifi/qa.getConnectedWifi.md',
                  collapsable: true,
                  sidebarDepth: 1
                },
                {
                  title: 'qa.getWifiList',
                  path: '/api/device/wifi/qa.getWifiList.md',
                  collapsable: true,
                  sidebarDepth: 1
                },
                {
                  title: 'qa.onGetWifiList',
                  path: '/api/device/wifi/qa.onGetWifiList.md',
                  collapsable: true,
                  sidebarDepth: 1
                },
                {
                  title: 'qa.onWifiConnected',
                  path: '/api/device/wifi/qa.onWifiConnected.md',
                  collapsable: true,
                  sidebarDepth: 1
                },
                {
                  title: 'qa.startWifi',
                  path: '/api/device/wifi/qa.startWifi.md',
                  collapsable: true,
                  sidebarDepth: 1
                },
                {
                  title: 'qa.stopWifi',
                  path: '/api/device/wifi/qa.stopWifi.md',
                  collapsable: true,
                  sidebarDepth: 1
                }
              ]
            }
          ]
        },
        {
          title: 'QXML', // required
          collapsable: true, // optional, defaults to true
          sidebarDepth: 1, // optional, defaults to 1
          children: [
            {
              title: 'IntersectionObserver.disconnect',
              path: '/api/qxml/IntersectionObserver.disconnect.md',
              collapsable: true,
              sidebarDepth: 1
            },
            {
              title: 'IntersectionObserver',
              path: '/api/qxml/IntersectionObserver.md',
              collapsable: true,
              sidebarDepth: 1
            },
            {
              title: 'IntersectionObserver.observe',
              path: '/api/qxml/IntersectionObserver.observe.md',
              collapsable: true,
              sidebarDepth: 1
            },
            {
              title: 'IntersectionObserver.relativeTo',
              path: '/api/qxml/IntersectionObserver.relativeTo.md',
              collapsable: true,
              sidebarDepth: 1
            },
            {
              title: 'IntersectionObserver.relativeToViewport',
              path: '/api/qxml/IntersectionObserver.relativeToViewport.md',
              collapsable: true,
              sidebarDepth: 1
            },
            {
              title: 'NodesRef.boundingClientRect',
              path: '/api/qxml/NodesRef.boundingClientRect.md',
              collapsable: true,
              sidebarDepth: 1
            },
            {
              title: 'NodesRef.context',
              path: '/api/qxml/NodesRef.context.md',
              collapsable: true,
              sidebarDepth: 1
            },
            {
              title: 'NodesRef.fields',
              path: '/api/qxml/NodesRef.fields.md',
              collapsable: true,
              sidebarDepth: 1
            },
            {
              title: 'NodesRef',
              path: '/api/qxml/NodesRef.md',
              collapsable: true,
              sidebarDepth: 1
            },
            {
              title: 'NodesRef.scrollOffset',
              path: '/api/qxml/NodesRef.scrollOffset.md',
              collapsable: true,
              sidebarDepth: 1
            },
            {
              title: 'SelectorQuery.exec',
              path: '/api/qxml/SelectorQuery.exec.md',
              collapsable: true,
              sidebarDepth: 1
            },
            {
              title: 'SelectorQuery.in',
              path: '/api/qxml/SelectorQuery.in.md',
              collapsable: true,
              sidebarDepth: 1
            },
            {
              title: 'SelectorQuery',
              path: '/api/qxml/SelectorQuery.md',
              collapsable: true,
              sidebarDepth: 1
            },
            {
              title: 'SelectorQuery.select',
              path: '/api/qxml/SelectorQuery.select.md',
              collapsable: true,
              sidebarDepth: 1
            },
            {
              title: 'SelectorQuery.selectAll',
              path: '/api/qxml/SelectorQuery.selectAll.md',
              collapsable: true,
              sidebarDepth: 1
            },
            {
              title: 'SelectorQuery.selectViewport',
              path: '/api/qxml/SelectorQuery.selectViewport.md',
              collapsable: true,
              sidebarDepth: 1
            },
            {
              title: 'qa.createIntersectionObserver',
              path: '/api/qxml/qa.createIntersectionObserver.md',
              collapsable: true,
              sidebarDepth: 1
            },
            {
              title: 'qa.createSelectorQuery',
              path: '/api/qxml/qa.createSelectorQuery.md',
              collapsable: true,
              sidebarDepth: 1
            }
          ]
        }
        // {
        //   title: '广告',   // required
        //   collapsable: true, // optional, defaults to true
        //   sidebarDepth: 1,    // optional, defaults to 1
        //   children: []
        // },
        // {
        //   title: 'Worker',   // required
        //   collapsable: true, // optional, defaults to true
        //   sidebarDepth: 1,    // optional, defaults to 1
        //   children: []
        // },
        // {
        //   title: '第三方平台',   // required
        //   collapsable: true, // optional, defaults to true
        //   sidebarDepth: 1,    // optional, defaults to 1
        //   children: []
        // },
      ],
      '/reference/': [
        {
          title: '快应用配置',
          collapsable: true,
          sidebarDepth: 1,
          children: [
            {
              title: '全局配置',
              collapsable: true,
              path: '/reference/configuration/app.md',
              sidebarDepth: 1
            },
            {
              title: '页面配置',
              path: '/reference/configuration/page.md',
              collapsable: true,
              sidebarDepth: 1
            }
          ]
        },
        {
          title: '框架接口',
          collapsable: true,
          sidebarDepth: 1,
          children: [
            {
              title: 'App',
              path: '/reference/api/App.md',
              collapsable: true,
              sidebarDepth: 1
            },
            {
              title: 'getApp',
              path: '/reference/api/getApp.md',
              collapsable: true,
              sidebarDepth: 1
            },
            {
              title: 'Page',
              path: '/reference/api/Page.md',
              collapsable: true,
              sidebarDepth: 1
            },
            {
              title: 'getCurrentPages',
              path: '/reference/api/getCurrentPages.md',
              collapsable: true,
              sidebarDepth: 1
            },
            {
              title: 'Component',
              path: '/reference/api/Component.md',
              collapsable: true,
              sidebarDepth: 1
            },
            {
              title: 'Behavior',
              path: '/reference/api/Behavior.md',
              collapsable: true,
              sidebarDepth: 1
            },
            {
              title: 'console',
              path: '/reference/api/console.md',
              collapsable: true,
              sidebarDepth: 1
            },
            {
              title: 'console.debug',
              path: '/reference/api/console.debug.md',
              collapsable: true,
              sidebarDepth: 1
            },
            {
              title: 'console.error',
              path: '/reference/api/console.error.md',
              collapsable: true,
              sidebarDepth: 1
            },
            {
              title: 'console.info',
              path: '/reference/api/console.info.md',
              collapsable: true,
              sidebarDepth: 1
            },
            {
              title: 'console.log',
              path: '/reference/api/console.log.md',
              collapsable: true,
              sidebarDepth: 1
            },
            {
              title: 'console.warn',
              path: '/reference/api/console.warn.md',
              collapsable: true,
              sidebarDepth: 1
            },
            {
              title: 'console.group',
              path: '/reference/api/console.group.md',
              collapsable: true,
              sidebarDepth: 1
            },
            {
              title: 'console.groupEnd',
              path: '/reference/api/console.groupEnd.md',
              collapsable: true,
              sidebarDepth: 1
            },
            {
              title: 'require',
              path: '/reference/api/require.md',
              collapsable: true,
              sidebarDepth: 1
            },
            {
              title: 'module',
              path: '/reference/api/module.md',
              collapsable: true,
              sidebarDepth: 1
            },
            {
              title: 'exports',
              path: '/reference/api/exports.md',
              collapsable: true,
              sidebarDepth: 1
            },
            {
              title: 'qa.env',
              path: '/reference/api/qa.env.md',
              collapsable: true,
              sidebarDepth: 1
            },
            {
              title: 'setInterval',
              path: '/reference/api/setInterval.md',
              collapsable: true,
              sidebarDepth: 1
            },
            {
              title: 'setTimeout',
              path: '/reference/api/setTimeout.md',
              collapsable: true,
              sidebarDepth: 1
            },
            {
              title: 'clearInterval',
              path: '/reference/api/clearInterval.md',
              collapsable: true,
              sidebarDepth: 1
            },
            {
              title: 'clearTimeout',
              path: '/reference/api/clearTimeout.md',
              collapsable: true,
              sidebarDepth: 1
            }
          ]
        },
        {
          title: 'QXML语法参考',
          path: '/reference/qxml',
          collapsable: true,
          sidebarDepth: 1,
          children: [
            {
              title: '数据绑定',
              path: '/reference/qxml/data.md',
              collapsable: true,
              sidebarDepth: 1
            },
            {
              title: '条件渲染',
              path: '/reference/qxml/conditional.md',
              collapsable: true,
              sidebarDepth: 1
            },
            {
              title: '列表渲染',
              path: '/reference/qxml/list.md',
              collapsable: true,
              sidebarDepth: 1
            },
            {
              title: '模版',
              path: '/reference/qxml/template.md',
              collapsable: true,
              sidebarDepth: 1
            },
            {
              title: '引用',
              path: '/reference/qxml/import.md',
              collapsable: true,
              sidebarDepth: 1
            }
          ]
        },
        {
          title: 'QJS语法参考',
          collapsable: true,
          sidebarDepth: 1,
          path: '/reference/qxs',
          children: [
            {
              title: 'QJS 模块',
              path: '/reference/qxs/01qjs-module.md',
              collapsable: true,
              sidebarDepth: 1
            },
            {
              title: '变量',
              path: '/reference/qxs/02variate.md',
              collapsable: true,
              sidebarDepth: 1
            },
            {
              title: '注释',
              path: '/reference/qxs/03annotation.md',
              collapsable: true,
              sidebarDepth: 1
            },
            {
              title: '运算符',
              path: '/reference/qxs/04operator.md',
              collapsable: true,
              sidebarDepth: 1
            },
            {
              title: '语句',
              path: '/reference/qxs/05statement.md',
              collapsable: true,
              sidebarDepth: 1
            },
            {
              title: '数据类型',
              path: '/reference/qxs/06datatype.md',
              collapsable: true,
              sidebarDepth: 1
            },
            {
              title: '基础类库',
              path: '/reference/qxs/07basiclibrary.md',
              collapsable: true,
              sidebarDepth: 1
            }
          ]
        }
      ],
      '/framework/': [
        {
          title: '快速开始',
          collapsable: true,
          sidebarDepth: 1,
          children: [
            {
              title: '快应用(Light)介绍',
              path: '/framework/quickstart/introduction.md',
              collapsable: true,
              sidebarDepth: 1
            },
            {
              title: '开始开发',
              path: '/framework/quickstart/getstart.md',
              collapsable: true,
              sidebarDepth: 1
            },
            {
              title: '代码构成',
              path: '/framework/quickstart/code.md',
              collapsable: true,
              sidebarDepth: 1
            },
            {
              title: '运行环境',
              path: '/framework/quickstart/framework.md',
              collapsable: true,
              sidebarDepth: 1
            },
            {
              title: '小程序转快应用light版',
              path: '/framework/quickstart/transform.md',
              collapsable: true,
              sidebarDepth: 1
            }
          ]
        },
        {
          title: '逻辑层',
          collapsable: true,
          sidebarDepth: 1,
          path: '/framework/app-service',
          children: [
            {
              title: '注册快应用',
              path: '/framework/app-service/app.md',
              collapsable: true,
              sidebarDepth: 1
            },
            {
              title: '注册页面',
              path: '/framework/app-service/page.md',
              collapsable: true,
              sidebarDepth: 1
            },
            {
              title: '模块化',
              path: '/framework/app-service/module.md',
              collapsable: true,
              sidebarDepth: 1
            },
            {
              title: '页面路由',
              path: '/framework/app-service/route.md',
              collapsable: true,
              sidebarDepth: 1
            },
            {
              title: 'api',
              path: '/framework/app-service/api.md',
              collapsable: true,
              sidebarDepth: 1
            }
          ]
        },
        {
          title: '渲染层',
          collapsable: true,
          path: '/framework/view',
          sidebarDepth: 1,
          children: [
            {
              title: '事件',
              path: '/framework/view/event.md',
              collapsable: true,
              sidebarDepth: 1
            },
            {
              title: 'QJS响应事件',
              path: '/framework/view/interactive-animation.md',
              collapsable: true,
              sidebarDepth: 1
            },
            {
              title: '基础组件',
              path: '/framework/view/component.md',
              collapsable: true,
              sidebarDepth: 1
            },
            {
              title: '动画',
              path: '/framework/view/animation.md',
              collapsable: true,
              sidebarDepth: 1
            },
            {
              title: '样式',
              path: '/framework/view/css.md',
              collapsable: true,
              sidebarDepth: 1
            },
            {
              title: '响应显示区域变化',
              path: '/framework/view/resizable.md',
              collapsable: true,
              sidebarDepth: 1
            }
          ]
        },
        {
          title: '自定义组件',
          collapsable: true,
          sidebarDepth: 1,
          children: [
            {
              title: '组件基础',
              path: '/framework/custom-component/basis.md',
              collapsable: true,
              sidebarDepth: 1
            },
            {
              title: '组件模板样式',
              path: '/framework/custom-component/qxml-css.md',
              collapsable: true,
              sidebarDepth: 1
            },
            {
              title: 'Component',
              path: '/framework/custom-component/component.md',
              collapsable: true,
              sidebarDepth: 1
            },
            {
              title: 'behaviors',
              path: '/framework/custom-component/behaviors.md',
              collapsable: true,
              sidebarDepth: 1
            },
            {
              title: '组件间通信与事件',
              path: '/framework/custom-component/events.md',
              collapsable: true,
              sidebarDepth: 1
            },
            {
              title: '组件扩展',
              path: '/framework/custom-component/extend.md',
              collapsable: true,
              sidebarDepth: 1
            },
            {
              title: '组件生命周期',
              path: '/framework/custom-component/lifetimes.md',
              collapsable: true,
              sidebarDepth: 1
            },
            {
              title: '数据监听器',
              path: '/framework/custom-component/observer.md',
              collapsable: true,
              sidebarDepth: 1
            }
          ]
        },
        {
          title: '功能模块',
          collapsable: true,
          sidebarDepth: 1,
          children: [
            {
              title: '画布',
              path: '/framework/ability/canvas.md',
              collapsable: true,
              sidebarDepth: 1
            },
            {
              title: '文件系统',
              path: '/framework/ability/filesystem.md',
              collapsable: true,
              sidebarDepth: 1
            },
            {
              title: '授权',
              path: '/framework/open-ability/authorize.md',
              collapsable: true,
              sidebarDepth: 1
            },
            {
              title: '微信支付',
              path: '/framework/open-ability/wxpay.md',
              collapsable: true,
              sidebarDepth: 1
            },
            {
              title: 'qa.env',
              path: '/framework/ability/qa.env.md',
              collapsable: true,
              sidebarDepth: 1
            },
            {
              title: 'URL 跳转配置',
              path: '/framework/platform/url.md',
              collapsable: true,
              sidebarDepth: 1
            },
          ]
        }
      ],
      '/component/': [
        {
          title: '视图容器',
          collapsable: true,
          sidebarDepth: 1,
          sidebarDepth: 1,
          children: [
            {
              title: 'view',
              path: '/component/view.md',
              collapsable: true,
              sidebarDepth: 1
            },
            {
              title: 'cover-image',
              path: '/component/cover-image.md',
              collapsable: true,
              sidebarDepth: 1
            },
            {
              title: 'cover-view',
              path: '/component/cover-view.md',
              collapsable: true,
              sidebarDepth: 1
            },
            {
              title: 'movable-area',
              path: '/component/movable-area.md',
              collapsable: true,
              sidebarDepth: 1
            },
            {
              title: 'movable-view',
              path: '/component/movable-view.md',
              collapsable: true,
              sidebarDepth: 1
            },
            {
              title: 'scroll-view',
              path: '/component/scroll-view.md',
              collapsable: true,
              sidebarDepth: 1
            },
            {
              title: 'swiper-item',
              path: '/component/swiper-item.md',
              collapsable: true,
              sidebarDepth: 1
            },
            {
              title: 'swiper',
              path: '/component/swiper.md',
              collapsable: true,
              sidebarDepth: 1
            }
          ]
        },
        {
          title: '基础容器',
          collapsable: true,
          sidebarDepth: 1,
          sidebarDepth: 1,
          children: [
            {
              title: 'icon',
              path: '/component/icon.md',
              collapsable: true,
              sidebarDepth: 1
            },
            {
              title: 'progress',
              path: '/component/progress.md',
              collapsable: true,
              sidebarDepth: 1
            },
            {
              title: 'rich-text',
              path: '/component/rich-text.md',
              collapsable: true,
              sidebarDepth: 1
            },
            {
              title: 'text',
              path: '/component/text.md',
              collapsable: true,
              sidebarDepth: 1
            }
          ]
        },
        {
          title: '表单组件',
          collapsable: true,
          sidebarDepth: 1,
          sidebarDepth: 1,
          children: [
            {
              title: 'button',
              path: '/component/button.md',
              collapsable: true,
              sidebarDepth: 1
            },

            {
              title: 'checkbox-group',
              path: '/component/checkbox-group.md',
              collapsable: true,
              sidebarDepth: 1
            },
            {
              title: 'checkbox',
              path: '/component/checkbox.md',
              collapsable: true,
              sidebarDepth: 1
            },

            {
              title: 'form',
              path: '/component/form.md',
              collapsable: true,
              sidebarDepth: 1
            },

            {
              title: 'input',
              path: '/component/input.md',
              collapsable: true,
              sidebarDepth: 1
            },
            {
              title: 'label',
              path: '/component/label.md',
              collapsable: true,
              sidebarDepth: 1
            },

            {
              title: 'native-component',
              path: '/component/native-component.md',
              collapsable: true,
              sidebarDepth: 1
            },

            {
              title: 'picker-view-column',
              path: '/component/picker-view-column.md',
              collapsable: true,
              sidebarDepth: 1
            },
            {
              title: 'picker-view',
              path: '/component/picker-view.md',
              collapsable: true,
              sidebarDepth: 1
            },
            {
              title: 'picker',
              path: '/component/picker.md',
              collapsable: true,
              sidebarDepth: 1
            },

            {
              title: 'radio-group',
              path: '/component/radio-group.md',
              collapsable: true,
              sidebarDepth: 1
            },
            {
              title: 'radio',
              path: '/component/radio.md',
              collapsable: true,
              sidebarDepth: 1
            },

            {
              title: 'slider',
              path: '/component/slider.md',
              collapsable: true,
              sidebarDepth: 1
            },

            {
              title: 'switch',
              path: '/component/switch.md',
              collapsable: true,
              sidebarDepth: 1
            },

            {
              title: 'textarea',
              path: '/component/textarea.md',
              collapsable: true,
              sidebarDepth: 1
            }
          ]
        },
        {
          title: '导航',
          collapsable: true,
          sidebarDepth: 1,
          sidebarDepth: 1,
          children: [
            {
              title: 'navigator',
              path: '/component/navigator.md',
              collapsable: true,
              sidebarDepth: 1
            }
          ]
        },
        {
          title: '媒体组件',
          collapsable: true,
          sidebarDepth: 1,
          sidebarDepth: 1,
          children: [
            {
              title: 'audio',
              path: '/component/audio.md',
              collapsable: true,
              sidebarDepth: 1
            },
            {
              title: 'image',
              path: '/component/image.md',
              collapsable: true,
              sidebarDepth: 1
            },
            {
              title: 'video',
              path: '/component/video.md',
              collapsable: true,
              sidebarDepth: 1
            }
          ]
        },
        {
          title: '地图',
          collapsable: true,
          sidebarDepth: 1,
          sidebarDepth: 1,
          children: [
            {
              title: 'map',
              path: '/component/map.md',
              collapsable: true,
              sidebarDepth: 1
            }
          ]
        },
        {
          title: '画布',
          collapsable: true,
          sidebarDepth: 1,
          sidebarDepth: 1,
          children: [
            {
              title: 'canvas',
              path: '/component/canvas.md',
              collapsable: true,
              sidebarDepth: 1
            }
          ]
        },
        {
          title: '开放能力',
          collapsable: true,
          sidebarDepth: 1,
          sidebarDepth: 1,
          children: [
            {
              title: 'web-view',
              path: '/component/web-view.md',
              collapsable: true,
              sidebarDepth: 1
            }
          ]
        }
      ]
    }
  }
}
