# 全局配置

快应用根目录下的 `app.json` 文件用来对快应用进行全局配置。有以下可配置项：

## 配置项

| 属性 | 类型 | <div style="width: 50px">必填</div> | 描述 |
| --- | --- | --- | --- |
| package | string | 是 | 应用包名，确认与原生应用的包名不一致，推荐采用 com.company.module 的格式，如：com.example.demo |  |
| name | string | 是 | 应用名称，6 个汉字以内，与应用商店保存的名称一致，用于在桌面图标、弹窗等处显示应用名称 |  |
| icon | string | 是 | 应用图标，提供 192x192 大小的即可 |  |
| versionName | string | 否 | 应用版本名称，如："1.0" |  |
| versionCode | Number | 是 | 应用版本号，从 1 自增，推荐每次重新上传包时 versionCode+1 |  |
| minPlatformVersion | Number | 否 | 支持的最小平台版本号，兼容性检查，避免上线后在低版本平台运行并导致不兼容；如果不填按照内测版本处理 |  |
| [pages](#pages) | string\[\] | 是 | 所有页面路径 |  |
| [window](#window) | Object | 否 | 全局的默认窗口样式 |  |
| [tabBar](#tabbar) | Object | 否 | `tab` 页设置 |  |
| [usingComponents](#usingcomponents) | Object | 否 | 全局[自定义组件](/framework/custom-component/basis.html)配置 |  |
| navigateToQuickAppList | string[] | 否 | 允许跳转的快应用包名列表 |  |
| [permission](#permission) |  Object |  否 |  快应用接口权限相关设置 |  |
| [wxpay](#wxpay) |  Object |  否 |  微信支付参数配置 |  |

### pages

指定快应用页面定义，每一项都对应一个页面的路径信息（含文件名）。文件名不需要写文件后缀，开发工具会自动去寻找对应位置的 `.json`, `.js`, `.qxml`, `.css` 文件进行处理。

- pages 第一项代表快应用的初始页面（首页）
- 在 pages 中添加一个路径后，需要有对应的文件存在，否则会导致编译报错

如开发目录为：

```bash
├── app.js
├── app.json
├── app.css
├── pages
│   │── index
│   │   ├── index.qxml
│   │   ├── index.js
│   │   ├── index.json
│   │   └── index.css
│   └── detail
│       ├── detail.qxml
│       └── detail.js
└── utils

```

则需要在 app.json 中写

```js
{
  "pages": ["pages/index/index", "pages/detail/detail"]
}

```

### window

快应用的状态栏、导航条、标题、窗口背景色配置项。

| 属性 | 类型 | <div style="width: 50px">默认值</div> | 描述 | 最低版本 |
| --- | --- | --- | --- | --- |
| navigationBarBackgroundColor | HexColor | #000000 | 导航栏背景颜色 |  |
| navigationBarTextStyle | string | white | 导航栏标题颜色，仅支持 `black` / `white` |  |
| navigationBarTitleText | string |  | 导航栏标题 |  |
| navigationStyle | string | default | 导航栏样式，仅支持以下值： `default` 默认样式；`custom` 自定义导航栏（只保留右上角胶囊按钮） |  |
| backgroundColor | HexColor | #ffffff | 窗口的背景色 |  |
| backgroundTextStyle | string | dark | 下拉 loading 的样式，仅支持 `dark` / `light` |  |
| enablePullDownRefresh | boolean | false | 是否开启下拉刷新。 详见 [Page.onPullDownRefresh](../api/Page.html#onpulldownrefresh) |  |
| onReachBottomDistance | number | 50 | 页面上拉触底事件触发时距页面底部距离，单位为 px。 详见 [Page.onReachBottom](../api/Page.html#onreachbottom) |  |
| pageOrientation | string | portrait | 屏幕旋转设置，支持 `auto` / `portrait` / `landscape` 详见 [响应显示区域变化](../../framework/view/resizable.html) |  |

- 注 1：HexColor 表示十六进制颜色值，如"#ff00ff"

如：

```json
{
  "window": {
    "navigationBarBackgroundColor": "#ffffff",
    "navigationBarTextStyle": "black",
    "navigationBarTitleText": "示例",
    "backgroundColor": "#cccccc",
    "backgroundTextStyle": "light"
  }
}
```

### tabBar

快应用允许多 tab 页。tab 页底部会有原生的 tab 切换栏。tab 页面路径、tab 栏显示图标、文字、样式等都可以通过 tabBar 配置项指定。

| 属性 | 类型 | <div style="width: 50px">必填</div> | <div style="width: 50px">默认值</div> | 描述 | 最低版本 |
| --- | --- | --- | --- | --- | --- |
| color | HexColor | 是 |  | tab 上的文字默认颜色，仅支持十六进制颜色 |  |
| selectedColor | HexColor | 是 |  | tab 上的文字选中时的颜色，仅支持十六进制颜色 |  |
| backgroundColor | HexColor | 是 |  | tab 的背景色，仅支持十六进制颜色 |  |
| borderStyle | string | 否 | black | tabbar 上边框的颜色， 仅支持 `black` / `white` |  |
| list | Array | 是 |  | tab 的列表，详见 `list` 属性说明，最少 2 个、最多 5 个 tab |  |
| position | string | 否 | bottom | tabBar 的位置，仅支持 `bottom` / `top` |  |

其中 list 的值是一个数组。tab 按数组的顺序排序，每个项都用对象配置一个 tab 页，对象属性值如下：

| 属性 | 类型 | <div style="width: 50px">必填</div> | 说明 |
| --- | --- | --- | --- |
| pagePath | string | 是 | 页面路径，必须在 pages 中先定义 |
| text | string | 是 | tab 上按钮文字 |
| iconPath | string | 否 | 图片路径，icon 大小限制为 40kb，建议尺寸为 81px \* 81px，不支持网络图片。 **当 `position` 为 `top` 时，不显示 icon。** |
| selectedIconPath | string | 否 | 选中时的图片路径，icon 大小限制为 40kb，建议尺寸为 81px \* 81px，不支持网络图片。 **当 `position` 为 `top` 时，不显示 icon。** |

**快应用允许最多配置五个 tab 页**

### usingComponents

在此处声明的自定义组件视为全局自定义组件，在快应用内的页面或自定义组件中可以直接使用而无需再声明。

## 配置示例

```js
{
  "pages": ["pages/index/index", "pages/detail/index"],
  "window": {
    "navigationBarTitleText": "Demo"
  },
  "tabBar": {
    "list": [
      {
        "pagePath": "pages/index/index",
        "text": "首页"
      },
      {
        "pagePath": "pages/detail/detail",
        "text": "详情"
      }
    ]
  }
}

```

### permission

快应用[接口权限](../../framework/open-ability/authorize.html)相关设置。字段类型为 `Object`，结构为：

| 属性 |  类型 |  必填 |  默认值 |  描述 |
| --- |  --- |  --- |  --- |  --- |
| scope.userLocation |  PermissionObject |  否 |   |  位置相关权限声明 |

**PermissionObject 结构**

| 属性 |  类型 |  必填 |  默认值 |  说明 |
| --- |  --- |  --- |  --- |  --- |
| desc |  string |  是 |   |  快应用获取权限时展示的接口用途说明。最长 30 个字符 |

如：

``` js
{
  "pages": ["pages/index/index"],
  "permission": {
    "scope.userLocation": {
      "desc": "你的位置信息将用于快应用位置接口的效果展示"
    }
  }
}

```

### wxpay

快应用支持微信支付的两种接入方式：[app支付](https://pay.weixin.qq.com/wiki/doc/api/app/app.php?chapter=9_1) 和 [网页支付](https://pay.weixin.qq.com/wiki/doc/api/H5.php?chapter=9_20)。

在使用微信支付时，需要根据需要配置下列参数，详细用法请参考 [快应用微信支付](../../framework/open-ability/wxpay.html), 快应用微信支付接口[qa.getWxPaymentType](../../api/open-api/wxpay/qa.getWxPaymentType.md) 和 [qa.requestWxPayment](../../api/open-api/wxpay/qa.requestWxPayment.md)。

| 属性 |  类型 |  必填 |  描述 |
| --- |  --- |  --- |  --- |
| package |  string |  微信app方式必填 | 微信支付后台中注册的应用包名，需要和 rpk 中的包名保持一致 |
| sign |  string |  微信app方式必填 |  微信支付后台注册时提交的 apk 的签名的 Base64 编码，该 apk 签名证书需要和 rpk 的签名证书保持一致 |
| url |  string |  微信网页中间页方式必填 | 由开发者提供的 H5 页面，开发者需要在该页面中拉起微信网页支付。当调用微信网页支付接口时，系统会加载该页面，并传入订单信息 |


## 配置示例

``` js
{
  "pages": ["pages/index/index", "pages/logs/index"],
  "window": {
    "navigationBarTitleText": "Demo"
  },
  "tabBar": {
    "list": [
      {
        "pagePath": "pages/index/index",
        "text": "首页"
      },
      {
        "pagePath": "pages/logs/logs",
        "text": "日志"
      }
    ]
  },
  "networkTimeout": {
    "request": 10000,
    "downloadFile": 10000
  }
}

```