# API

快应用框架提供了丰富的 API，方便开发者使用系统能力，如打开蓝牙，使用文件存储等。详细接口列表请参考 [API 文档](../../api/index.html)。

## 异步 API 回调说明

大多数 API 都是异步 API，如 [qa.request](../../api/network/request/qa.request.html) 等。这类 API 接口一般接受一个 `Object` 类型的参数，参数中指定 `success`，`fail` 或 `complete` 回调来获取异步返回的结果。

**异步 API Object 参数说明**

| 参数名   | 类型     | 必填 | 说明                                             |
| -------- | -------- | ---- | ------------------------------------------------ |
| success  | function | 否   | 接口调用成功的回调函数                           |
| fail     | function | 否   | 接口调用失败的回调函数                           |
| complete | function | 否   | 接口调用结束的回调函数（调用成功、失败都会执行） |
| 其他     | Any      | \-   | 接口定义的其他参数                               |

**回调函数的参数**

`success`，`fail`，`complete` 函数调用时会传入一个 `Object` 类型参数，包含如下字段：

| 属性    | 类型   | 说明                                                                 |
| ------- | ------ | -------------------------------------------------------------------- |
| errMsg  | string | 错误信息，如果调用成功返回 `${apiName}:ok`                           |
| errCode | number | 错误码，仅部分 API 支持，具体含义请参考对应 API 文档，成功时为 `0`。 |
| 其他    | Any    | 接口返回的其他数据                                                   |

部分异步 API 也会有同步返回值，可以用来进行额外的操作，如 [qa.request](../../api/network/request/qa.request.html)，[qa.connectSocket](../../api/network/websocket/qa.connectSocket.html) 等。

**代码示例**

```js
qa.login({
  success(res) {
    console.log(res.code)
  }
})
```
