# 组件基础

开发者可以将功能模块抽象成自定义组件，便于在不同的页面中重复使用。

### 创建自定义组件

和页面类似，自定义组件也由 `json` `qxml` `css` `js` 4 类文件组成。定义一个自定义组件：

- 需要在 `json` 文件中声明 `"component": true`
- 需要在 `js` 文件中调用 `Component` 构造方法
- 在 `qxml` 文件中编写组件模板，细节参见 [组件模板和样式](./qxml-css.html)
- 在 `css` 文件中编写组件样式，细节参见 [组件模板和样式](./qxml-css.html)

下面以 index 页面 custom 组件为例

```
// 页面 index 及自定义组件 custom 项目结构
└── index
    ├── components
    │   └── custom
    │       ├── custom.css
    │       ├── custom.js
    │       ├── custom.json
    │       └── custom.qxml
    ├── index.css
    ├── index.js
    ├── index.json
    └── index.qxml
```

需要再 custom.json 中设置 `"component": true`

```json
{
  "component": true
}
```

通过 Component 构造器定义组件内部数据和方法等，细节参见 [Component 构造器](./component.html)

```js
// custom.js
Component({
  // 定义组件内部数据
  data: {
    name: 'custom-component'
  },
  // 自定组件内部方法
  methods: {
    customMethod() {}
  }
})
```

在 qxml 和 css 文件中编写模板和样式

```html
<!-- custom.qxml -->
<view class="name">
  {{name}}
</view>
```

```css
/* custom.css */
/* 组件内部样式 */
.name {
  text-align: center;
}
```

### 使用自定义组件

使用自定义组件，首先需要在页面的 `json` 文件中进行引用声明，即在 `usingComponents` 字段下设置标签名及对应的组件路径。

```json
{
  "usingComponents": {
    "custom": "./components/custom/custom"
  }
}
```

这样，在页面的 `qxml` 中就可以像使用基础组件一样使用自定义组件。节点名即自定义组件的标签名。

- app.json 字段 usingComponents 里声明的自定义组件是全局组件，可以在所有页面和自定义组件中直接使用，无需再次声明。
- 自定义组件也是可以引用自定义组件的，引用方法类似于页面引用自定义组件的方式（使用 `usingComponents` 字段）

**代码示例：**

```html
<!-- index.qxml -->
<view>
  <custom />
</view>
```

自定义组件的 `qxml` 节点结构在与数据结合之后，将被插入到引用位置内。

### 注意事项

- 自定义组件的标签名只能是小写字母、数字、中划线和下划线的组合，并且需要以字母开头。
