# qa.startRecord(Object object)

> 调用时需要获得 [用户授权](../../../framework/open-ability/authorize.html) scope.record

推荐通过 [qa.getRecorderManager](qa.getRecorderManager.html) 来实现录音功能

开始录音，主动调用 [qa.stopRecord](qa.stopRecord.html)接口，或者录音超过 1 分钟时会自动结束录音。

当用户离开快应用时，此接口无法调用。

## 参数

### Object object

| 属性 | 类型 | <div style="width: 50px">默认值</div> | <div style="width: 50px">必填</div> | 说明 |
| --- | --- | --- | --- | --- |
| success | function |  | 否 | 接口调用成功的回调函数 |
| fail | function |  | 否 | 接口调用失败的回调函数 |
| complete | function |  | 否 | 接口调用结束的回调函数（调用成功、失败都会执行） |

#### object.success 回调函数

##### 参数

###### Object res

| 属性         | 类型   | 说明               |
| ------------ | ------ | ------------------ |
| tempFilePath | string | 录音文件所对应的临时路径 |

## 示例代码

```js
qa.startRecord({
  success(res) {
    const tempFilePath = res.tempFilePath
  }
})
setTimeout(function() {
  qa.stopRecord() // 结束录音
}, 10000)
```
