# QXML

QXML 是快应用的标签语言，和 HTML 很类似。 QXML 结合[基础组件](../../component/index.html)、[事件系统](../../framework/view/event.html)，可以构建出页面的结构。

下面简单展示一下 QXML 的用法：

### [数据绑定](./data.html)

```html
<!--QXML-->
<view> {{message}} </view>
```

```js
// page.js
Page({
  data: {
    message: 'Hello QuickApp!'
  }
})
```

### [列表渲染](./list.html)

```html
<!--QXML-->
<view qa:for="{{array}}"> {{item}} </view>
```

```js
// page.js
Page({
  data: {
    array: [1, 2, 3, 4, 5]
  }
})
```

### [条件渲染](./conditional.html)

```html
<!--QXML-->
<view qa:if="{{view == 'WEBVIEW'}}"> WEBVIEW </view>
<view qa:elif="{{view == 'APP'}}"> APP </view>
<view qa:else="{{view == 'QuickApp'}}"> QuickApp </view>
```

```js
// page.js
Page({
  data: {
    view: 'QuickApp'
  }
})
```

### [模板](./template.html)

```html
<!--QXML-->
<template name="staffName">
  <view>
    FirstName: {{firstName}}, LastName: {{lastName}}
  </view>
</template>

<template is="staffName" data="{{...staffA}}"></template>
<template is="staffName" data="{{...staffB}}"></template>
```

```js
// page.js
Page({
  data: {
    staffA: { firstName: 'Andy', lastName: 'Lin' },
    staffB: { firstName: 'Shang', lastName: 'You' }
  }
})
```

更多详情查看：

[数据绑定](./data.html)、[列表渲染](./list.html)、[条件渲染](./conditional.html)、[模板](./template.html)、[引用](./import.html)
