# qa.requestWxPayment(Object object)

发起微信支付

微信支付详细使用方式请参考[微信支付说明](../../../framework/open-ability/wxpay.html)

## 参数

### Object object

| 属性 | 类型 | <div style="width: 50px">必填</div> | 说明 |
| --- | --- | --- | --- |
| prepayid | string | 是 | 微信支付服务器生成的预支付订单 id，参考[微信 app 支付](https://pay.weixin.qq.com/wiki/doc/api/app/app.php?chapter=9_1)和[微信网页支付](https://pay.weixin.qq.com/wiki/doc/api/H5.php?chapter=9_20) |
| referer | string | 否 | 在微信支付后台配置的域名，若该参数不为空，将通过直接设置 referer 的方式拉起微信客户端。 |
| extra | Object | 否 | 当前支付方式下，需要填入的额外订单信息，具体见下文的 extra 参数说明 |
| success | function | 否 | 成功后的回调函数，App 方式下，回调发生在用户支付完成之后，网页方式下，回调发生在订单提交给微信 app 之后 |
| fail | function | 否 | 接口调用失败的回调函数 |
| cancel | function | 否 | 用户取消的回调函数 |
| complete | function | 否 | 接口调用结束的回调函数（调用成功、失败都会执行） |

#### extra 参数

app 方式

| 字段名        | 必选 | 说明                           |
| ------------- | ---- | ------------------------------ |
| app_id        | 是   | 微信支付订单中的 app_id        |
| partner_id    | 是   | 微信支付订单中的 partner_id    |
| package_value | 是   | 微信支付订单中的 package_value |
| nonce_str     | 是   | 微信支付订单中的 nonce_str     |
| time_stamp    | 是   | 微信支付订单中的 time_stamp    |
| order_sign    | 是   | 微信支付订单中的 order_sign    |

网页方式（referer 方式）

| 字段名      | 必选 | 说明                                                              |
| ----------- | ---- | ----------------------------------------------------------------- |
| mweb_url    | 是   | 在微信的支付服务器下单以后，微信返回的 MWEB_URL                   |
| custome_key | 否   | 其他的自定义键值，cp 可以根据需要增加其他自己认为需要的键名和键值 |

网页方式（中间页方式）

| 字段名 | 必选 | 说明 |
| --- | --- | --- |
| mweb_url | 否 | 在微信的支付服务器下单以后，微信返回的 MWEB_URL，在 CP 用于微信支付的 h5 页面中，直接将 mweb_url 取出后跳转过去即可，但这个做法并不是强制的，您也可以通过其他自定义键值向您自己的服务器换取 MWEB_URL。 |
| custome_key | 否 | 其他的自定义键值，cp 可以根据需要增加其他自己认为需要的键名和键值 |

#### object.fail 回调函数

##### 参数

###### Object res.errCode

| 错误码 | 说明 |
| --- | --- |
| 900 | 在 manifest.json 中配置的应用签名有误，无法解析 |
| 901 | 在 manifest.json 中配置的应用包名有误 |
| 1000 | 微信未安装 |
| 1001 | 用于微信网页支付的 url 配置找不到 |
| 2001 | 订单已经提交给微信，但是微信返回错误, 可能的原因：签名错误、未注册 APPID、项目设置 APPID 不正确、注册的 APPID 与设置的不匹配、其他异常等。 |

## 示例代码

APP 方式

```js
var payType = qa.getWxPaymentType()
if (payType === 'APP') {
  qa.requestWxPayment({
    //微信 app支付的prepayId
    prepayid: 'your order prepayid,eg: wx20170101abcdef1234567890',
    extra: {
      app_id: 'your app_id',
      partner_id: 'your partner_id',
      package_value: 'your package_value',
      nonce_str: 'your nonce_str',
      time_stamp: 'your time_stamp',
      order_sign: 'your order sign'
    },
    fail: function(ret) {
      console.log(`WX PAY failed, code = ${ret.errCode}`)
    },
    cancel: function() {
      console.log('WX PAY cancelled by user')
    },
    success: function() {
      console.log('WX PAY success')
    }
  })
}
```

网页方式（referer 方式）

```js
var payType = qa.getWxPaymentType()
if (payType === 'MWEB') {
  qa.requestWxPayment({
    // 微信网页支付的prepayId
    prepayid: 'your order prepayid,eg: wx20170101abcdef1234567890',
    referer: 'your host name configured in wechat, eg: https://www.quickapp.cn',
    extra: {
      // 需要将微信返回的MWEB_URL地址配置到这里
      mweb_url: 'https://wx.tenpay.com/cgi-bin/mmpayweb-bin'
    },
    fail: function(ret) {
      console.log(`WX H5 PAY handling fail, code = ${ret.errCode}`)
    },
    cancel: function() {
      console.log('WX H5 PAY handling cancel')
    },
    success: function(data) {
      //H5方式下，支付成功的回调仅仅只是指将订单递交给微信，并不意味着支付已经成功完成
      console.log('WX H5 PAY handling success')
    }
  })
}
```

网页方式（中间页方式）

```js
var payType = qa.getWxPaymentType()
if (payType === 'MWEB') {
    qa.requestWxPayment({
      //微信网页支付的prepayId
      prepayid: 'your order prepayid,eg: wx20170101abcdef1234567890',
      extra: {
        //传递给支付页面的自定义参数, 根据需要进行设置, 会被urlEncode之后拼接在配置的url尾部
        mweb_url: 'https://wx.tenpay.com/cgi-bin/mmpayweb-bin',
        customeKey1: 'customeValue1',
        customeKey2: 'customeValue2'
      },
      fail: function (ret) {
        console.log(`WX H5 PAY handling fail, code = ${ret.errCode}`)
      },
      cancel: function () {
        console.log('WX H5 PAY handling cancel')
      },
      success: function () {
        //H5方式下，支付成功的回调仅仅只是指将订单递交给微信，并不意味着支付已经成功完成
        console.log('WX H5 PAY handling success')
      }
    })
  } else {
     console.log('WX PAY is not avaliable')
  }
}
```
