# qa.requestVendorPayment(Object object)

使用设备商提供的支付完成付款

## 参数

### Object object

| 属性 | 类型 | <div style="width: 50px">默认值</div> | <div style="width: 50px">必填</div> | 说明 |
| --- | --- | --- | --- | --- |
| orderInfo | string |  | 是 | 支付订单信息 |
| success | function |  | 否 | 接口调用成功的回调函数 |
| fail | function |  | 否 | 接口调用失败的回调函数 |
| cancel | function | 否 | 用户取消的回调函数 |
| complete | function |  | 否 | 接口调用结束的回调函数（调用成功、失败都会执行） |

#### object.success 回调函数

##### 参数

###### Object res

| 属性    | 类型   | 说明       |
| ------- | ------ | ---------- |
| code    | number | 返回状态码 |
| message | string | 消息内容   |
| result  | string | 支付结果   |

#### object.fail & object.cancel 回调函数

##### 参数

###### Object res

| 属性    | 类型   | 说明       |
| ------- | ------ | ---------- |
| code    | number | 返回状态码 |
| message | string | 消息内容   |

## 示例代码

```js
qa.requestVendorPayment({
  orderInfo: 'order1',
  success(res) {
    console.log(`handling success`)
  },
  fail(res) {
    console.log(`handling fail, code = ${res.errCode}`)
  }
})
```
