# QJS 模块

QJS 代码可以编写在 QXML 文件中的 `<qjs>` 标签内，也可以单独写在 `.qjs` 文件内。每一个 `<qjs>` 标签和`.qjs` 文件都是一个单独的模块。

## 模块

模块具有独立作用域。一个模块里面定义的变量与函数，其他模块不可见，无法直接使用。

但模块可以通过 `module.exports` 对外导出变量或函数。

## .qjs 文件

**示例代码：**

```js
// /pages/common.qjs

var foo = "'Hello QuickApp' from common.qjs"
var bar = function(d) {
  return d
}
module.exports = {
  foo: foo,
  bar: bar
}
```

上述例子在 `/pages/common.qjs` 的文件里编写了 QJS 代码，并用 `module.exports` 导出。该 `.qjs` 文件可以被其他的 `.qjs` 文件 或 QXML 中的 `<qjs>` 标签引入使用。

### module 对象

`qjs` 模块内有一个内置的 `module` 对象。 `module` 对象具有 `exports` 属性， 通过该属性，可以导出模块内的变量和函数。

**示例代码：**

```js
// /pages/utils.qjs

var foo = "'hello QuickApp' from utils.qjs"
var bar = function(d) {
  return d
}
module.exports = {
  foo: foo,
  bar: bar
}
module.exports.message = 'some message'
```

```js
<!-- page/index/index.qxml -->

<qjs src="./../utils.qjs" module="utils" />
<view> {{utils.message}} </view>
<view> {{utils.bar(utils.foo)}} </view>

```

页面显示：

```bash
some message
'Hello QuickApp' from utils.qjs

```

### require 函数

在`.qjs`模块中引用其他 `qjs` 模块，可以使用 `require` 函数。

引用的时候，要注意如下几点：

- 只能引用 `.qjs` 文件模块，需要使用相对路径。
- `qjs` 模块为单例，多次引用，使用的都是同一个 `qjs` 模块对象。
- 需要至少被引入一次， `qjs` 才会运行。

**示例代码：**

```js
// /pages/utils.qjs

var foo = "'Hello QuickApp' from utils.qjs"
var bar = function(d) {
  return d
}
module.exports = {
  FOO: foo,
  bar: bar
}
module.exports.msg = 'some msg'
```

```js
// /pages/mock.qjs

var utils = require('./utils.qjs')

console.log(utils.FOO)
console.log(utils.bar('mock.qjs'))
console.log(utils.msg)
```

```html
<!-- /page/index/index.qxml -->

<qjs src="./../mock.qjs" module="mock" />
```

控制台输出：

```bash
'Hello QuickApp' from utils.qjs
mock.qjs
some msg

```

## `<qjs>` 标签

| 属性名 | 类型   | <div style="width: 50px">默认值</div> | 说明                                  |
| ------ | ------ | ------------------------------------- | ------------------------------------- |
| module | String |                                       | 当前 `<qjs>` 标签的模块名。必填字段。 |
| src    | String |                                       | 引用 .qjs 文件的相对路径。            |

### module 属性

module 属性定义当前 `<qjs>` 标签的模块名。在单个 QXML 文件内，先定义的模块会被后定义的重名模块覆盖。

module 属性值的名称只能由字母（a-zA-Z）、数字（0-9）和下划线（\_）构成，并且只能以字母或下划线开头。

**示例代码：**

```html
<!--QXML-->

<qjs module="utils">
  var message = "Hello QuickApp"; module.exports = { msg : message, }
</qjs>
<view> {{utils.msg}} </view>
```

页面输出：

```bash
Hello QuickApp

```

上面例子声明了一个名字为 `utils` 的模块，将 `message` 变量暴露出来，供当前页面使用。

### src 属性

src 属性可以用来引用其他的 `qjs` 文件模块。

引用的时候，要注意如下几点：

- 只能引用 `.qjs` 文件模块，需要使用相对路径。
- `qjs` 模块为单例，多次引用，使用的都是同一个 `qjs` 模块对象。
- 需要至少被引入一次， `qjs` 才会运行。

**示例代码：**

```js
// /pages/index/index.js

Page({
  data: {
    msg: "'Hello QuickApp' from js"
  }
})
```

```html
<!-- /pages/index/index.qxml -->

<qjs src="./../common.qjs" module="commonQJS"></qjs>
<!-- 也可以使用单闭合标签
<qjs src="./../common.qjs" module="commonQJS" />
-->

<!-- 调用 commonQJS 模块里面的 bar 函数，且参数为 commonQJS 模块里面的 foo -->
<view> {{commonQJS.bar(commonQJS.foo)}} </view>
<!-- 调用 commonQJS 模块里面的 bar 函数，且参数为 page/index/index.js 里面的 msg -->
<view> {{commonQJS.bar(msg)}} </view>
```

页面输出：

```js
'Hello QuickApp' from common.qjs
'Hello QuickApp' from js

```

上述例子在文件 `/page/index/index.qxml` 中通过 `<qjs>` 标签引用了 `/page/common.qjs` 模块。

### 注意

- `<qjs>` 模块只能在定义模块的 QXML 文件中被访问到。使用 `<include>` 或 `<import>` 时，不会引入 `<qjs>` 模块。
- `<template>` 标签中，只能使用定义该 `<template>` 的 QXML 文件中定义的 `<qjs>` 模块。
