# 模板

有时一部分代码在很多处都会用到，这时可以利用 QXML 的模板功能，将其定义为模板，然后在使用时调用。

### 定义模板

模板定义在 `<template/>` 内， name 属性定义模板的名称。如：

```html
<template name="msgBox">
  <view>
    <text> {{index}}: {{msg}} </text>
    <text> Time: {{time}} </text>
  </view>
</template>
```

### 使用模板

使用模板时，也用 `<template/>` 标签，但是不能有 name 属性。使用 is 属性声明需要的使用的模板名称；使用 data 属性传入外部数据，如：

```html
<template is="msgBox" data="{{ {...item} }}" />
```

```js
Page({
  data: {
    item: {
      index: 0,
      msg: 'template msg',
      time: '2019-10-01'
    }
  }
})
```

is 属性可以绑定变量，动态决定使用哪个模板：

```html
<template name="odd">
  <view> odd </view>
</template>
<template name="even">
  <view> even </view>
</template>

<block qa:for="{{[1, 2, 3, 4, 5]}}">
  <template is="{{item % 2 == 0 ? 'even' : 'odd'}}" />
</block>
```

### 模板的作用域

模板的作用域是独立的，只能使用 data 传入的数据以及引入的 `<qjs />` 模块数据。
