# 引用

快应用 QXML 文件引用方式有 `import`和`include` 两种。

### import

`import` 一个目标文件后，可以在当前文件中使用目标文件中定义的 `template` 。如：

在 template.qxml 中定义了一个叫 `item` 的 `template`：

```html
<!-- template.qxml -->
<template name="item">
  <text>{{text}}</text>
</template>
```

在 index.qxml 中引用了 template.qxml 后，就可以使用 `item` 模板：

```html
<import src="template.qxml" />
<template is="item" data="{{text: 'Hello QuickApp'}}" />
```

### import 的作用域

`import` 只会引入直接目标文件的 template， 而不会引入目标文件 import 的 template。

比如 C import B，B import A，那么：

- 在 B 中可以使用 A 定义的`template`
- 在 C 中可以使用 B 定义的 `template`, 但不能使用 A 定义的 `template`

```html
<!-- A.qxml -->
<template name="A">
  <text> A template </text>
</template>
```

```html
<!-- B.qxml -->
<import src="a.qxml" />
<template name="B">
  <text> B template </text>
</template>
```

```html
<!-- C.qxml -->
<import src="b.qxml" />
<template is="A" />
<!-- 无法使用 A -->
<template is="B" />
```

### include

`include` 的作用相当于代码拷贝。可以将目标文件除了 `<template/>` `<qjs/>` 外的代码复制到 `include` 位置，如：

```html
<!-- index.qxml -->
<include src="header.qxml" />
<view> body </view>
<include src="footer.qxml" />
```

```html
<!-- header.qxml -->
<view> header </view>
```

```html
<!-- footer.qxml -->
<view> footer </view>
```
