# 条件渲染

### qa:if

快应用框架提供了 `qa:if` `qa:elif` 和 `qa:else` 指令来控制组件是否渲染。

```html
<view qa:if="{{condition}}"> True </view>
```

```html
<view qa:if="{{length > 5}}"> 1 </view>
<view qa:elif="{{length > 2}}"> 2 </view>
<view qa:else> 3 </view>
```

### block qa:if

如果要一次性控制多个组件标签，可以使用一个 `<block/>` 标签将多个组件包装起来，并在上边使用 `qa:if` 指令。

```html
<block qa:if="{{condition}}">
  <view> view1 </view>
  <view> view2 </view>
</block>
```

### `qa:if` 和 `hidden`

- `qa:if`: 当值为 `true` 时，对应组件才会渲染，值变为 `false` 时会销毁。
- `hidden`: 对应组件始终会渲染，其值控制的只是显示与隐藏。
