# 页面配置

快应用页面也可以使用 `json` 文件来对本页面的窗口样式进行配置。页面 json 配置的优先级高于 `app.json` 的 `window` 配置。具体配置项如下：

## 配置项

| 属性 | 类型 | <div style="width: 50px">默认值</div> | 描述 |
| --- | --- | --- | --- |
| navigationBarBackgroundColor | HexColor | #000000 | 导航栏背景颜色 |  |
| navigationBarTextStyle | string | white | 导航栏标题颜色，仅支持 `black` / `white` |  |
| navigationBarTitleText | string |  | 导航栏标题文字内容 |  |
| navigationStyle | string | default | 导航栏样式，仅支持以下值： `default` 默认样式 ;`custom` 自定义导航栏（只保留右上角胶囊按钮） |  |
| backgroundColor | HexColor | #ffffff | 窗口的背景色 |  |
| backgroundTextStyle | string | dark | 下拉 loading 的样式，仅支持 `dark` / `light` |  |
| enablePullDownRefresh | boolean | false | 是否开启本页面下拉刷新。 详见 [Page.onPullDownRefresh](../api/Page.html#onpulldownrefresh) |  |
| onReachBottomDistance | number | 50 | 页面上拉触底事件触发时距页面底部距离，单位为 px。 详见 [Page.onReachBottom](../api/Page.html#onreachbottom) |  |
| pageOrientation | string | portrait | 屏幕旋转设置，支持 `auto` / `portrait` / `landscape` 详见 [响应显示区域变化](../../framework/view/resizable.html) |  |
| disableScroll | boolean | false | 设置为 `true` 则页面整体不能上下滚动。 只在页面配置中有效，无法在 `app.json` 中设置 |  |
| usingComponents | Object | 否 | 页面[自定义组件](./../../framework/custom-component/basis.html)配置 |  |

## 配置示例

```json
{
  "navigationBarBackgroundColor": "#ffffff",
  "navigationBarTextStyle": "black",
  "navigationBarTitleText": "接口功能演示",
  "backgroundColor": "#eeeeee",
  "backgroundTextStyle": "light"
}
```
