## Component(Object object)

定义自定义组件。

### 参数

#### Object object

| 定义段 | 类型 | <div style="width: 50px">必填</div> | 描述 |
| --- | --- | --- | --- |
| properties | Object Map | 否 | 组件的对外属性定义 |  |
| data | Object | 否 | 组件的内部数据，和 `properties` 一同用于组件的模板渲染 |  |
| observers | Object | 否 | 组件数据字段监听器，用于监听 properties 和 data 的变化，参见 [数据监听器](../../framework/custom-component/observer.html) |  |
| methods | Object | 否 | 组件的自定义方法，可用于事件响应，关于事件响应函数的使用，参见 [组件间通信与事件](../../framework/custom-component/events.html) |  |
| behaviors | String Array | 否 | 组件间代码复用机制，参见 [behaviors](../../framework/custom-component/behaviors.html) |  |
| created | Function | 否 | 组件生命周期函数-在组件实例被创建时执行 |  |
| attached | Function | 否 | 组件生命周期函数-在组件实例进入页面节点树时执行 |  |
| ready | Function | 否 | 组件生命周期函数-在组件布局完成后执行 |  |
| detached | Function | 否 | 组件生命周期函数-在组件实例从页面中移除时执行 |  |
| lifetimes | Object | 否 | 组件生命周期声明对象，参见 [组件生命周期](../../framework/custom-component/lifetimes.html) |  |
| pageLifetimes | Object | 否 | 组件所在页面的生命周期声明对象，参见 [组件生命周期](../../framework/custom-component/lifetimes.html) |  |

组件自定义方法、生命周期函数、属性 observer 方法中都可以通过 `this` 访问当前组件实例。组件实例包含下面属性和方法：

| 属性名     | 类型   | 描述                                                                  |
| ---------- | ------ | --------------------------------------------------------------------- |
| is         | String | 组件的文件路径                                                        |
| id         | String | 节点 id                                                               |
| dataset    | String | 节点 dataset                                                          |
| data       | Object | 组件数据，**包括内部数据和属性值**                                    |
| properties | Object | 组件数据，**包括内部数据和属性值**（`this.data === this.properties`） |

| 方法名 | <div style="width: 150px;">参数</div> | 描述 |
| --- | --- | --- |
| setData | Object `newData` | 设置 data 并触发渲染层更新 |  |
| hasBehavior | Object `behavior` | 检查组件是否具有 `behavior` （检查时会递归检查被直接或间接引入的所有 behavior） |  |
| triggerEvent | String `name`, Object `detail` | 触发事件，参见 [组件间通信与事件](../../framework/custom-component/events.html) |  |
| createSelectorQuery |  | 创建一个 [SelectorQuery](../../api/qxml/SelectorQuery.html) 对象，选择器选取范围为这个组件实例内 |  |
| createIntersectionObserver |  | 创建一个 [IntersectionObserver](../../api/qxml/IntersectionObserver.html) 对象，选择器选取范围为这个组件实例内 |  |
| selectComponent | String `selector` | 选择组件实例节点，返回匹配到的第一个组件实例对象（返回结果受 `qa://component-export` 影响） |  |
| selectAllComponents | String `selector` | 选择组件实例节点，返回匹配到的全部组件实例对象组成的数组 |  |
| groupSetData | Function `callback` | 立刻执行 `callback` |  |

**代码示例：**

```js
Component({
  behaviors: [],

  // 属性定义（见下文）
  properties: {
    prop1: {
      // 属性名
      type: String,
      value: ''
    },
    prop2: String // 简化的定义方式
  },

  data: {}, // 内部数据，可用于模板渲染

  lifetimes: {
    // 生命周期函数
    attached: function() {},
    moved: function() {},
    detached: function() {}
  },

  // 生命周期函数
  attached: function() {}, // 此处attached的声明会被lifetimes字段中的声明覆盖
  ready: function() {},

  pageLifetimes: {
    // 组件所在页面的生命周期函数
    show: function() {},
    hide: function() {},
    resize: function() {}
  },

  methods: {
    handleTap: function() {
      this.setData({
        // 和页面 setData 一致
      })
    }
  }
})
```

::: warning 注意：在 `properties` 定义段中，属性名采用驼峰写法（`propertyName`）；在 `QXML` 中，标签属性名应使用连字符写法（如`<comp prop-name="name value"></comp>`）。

:::

## properties 定义

| 定义段        | 类型     | 是否必填 | 描述                       |
| ------------- | -------- | -------- | -------------------------- |
| type          |          | 是       | 属性的类型                 |  |
| optionalTypes | Array    | 否       | 属性的类型（可以指定多个） |  |
| value         |          | 否       | 属性的初始值               |  |
| observer      | Function | 否       | 属性值变化时的回调函数     |  |

observer 可以监听属性值的改变，第一个参数是新的值，第二个参数是旧的值。

**代码示例：**

```js
Component({
  properties: {
    min: {
      type: Number,
      value: 0
    },
    min: {
      type: Number,
      value: 0,
      observer: function(newValue, oldValue) {
        // 属性值变化时执行
      }
    },
    lastLeaf: {
      // 这个属性可以是 Number 、 String 、 Boolean 三种类型中的一种
      type: Number,
      optionalTypes: [String, Object],
      value: 0
    }
  }
})
```

属性的类型可以为 `String` `Number` `Boolean` `Object` `Array` ， 不设置代表类型不限。

#### 提示:

::: warning

- 直接修改 `this.data` 的值无法触发页面更新，应使用 `setData` 修改
- properties 和 data 里的字段名不能相同

:::
