# 响应显示区域变化

快应用显示区域在页面初始化后一般不再变化，只有在屏幕旋转时会有所变动。

### 屏幕旋转设置

设置开启屏幕旋转：在 `app.json` 的 `window` 段中设置 `"pageOrientation": "auto"` ，或在页面 json 文件中配置 `"pageOrientation": "auto"` 。

**单个页面 json 中启用屏幕旋转代码示例：**

```json
{
  "pageOrientation": "auto"
}
```

## 显示区域变化事件

开启屏幕旋转设置后，屏幕旋转时会引起显示区域变化。开发者可以用 css 的 media query 对布局做调整，也可以监听显示区域变化事件，动态设置样式。

监听显示区域变化事件的方法：

1. `Page` 中定义 `onResize`
2. `Component` 中定义 `pageLifetimes.resize`

**代码示例：**

```js
Page({
  onResize(res) {
    res.size.windowWidth // 新的显示区域宽度
    res.size.windowHeight // 新的显示区域高度
  }
})
```

```js
Component({
  pageLifetimes: {
    resize(res) {
      res.size.windowWidth // 新的显示区域宽度
      res.size.windowHeight // 新的显示区域高度
    }
  }
})
```

另外，开发者还可以使用 [selectorQuery.selectViewport](../../api/qxml/SelectorQuery.selectViewport.html) 获取显示区域尺寸。
