# 动画

## 常用的动画方式：

1. 使用 [CSS 渐变](https://developer.mozilla.org/zh-CN/docs/Web/CSS/CSS_Transitions/Using_CSS_transitions) 和 [CSS 动画](https://developer.mozilla.org/zh-CN/docs/Web/CSS/CSS_Animations/Using_CSS_animations) 创建界面动画
2. 使用 [qa.createAnimation](../../api/ui/animation/qa.createAnimation.html) 接口创建动画
3. 使用 [QJS 响应事件](./interactive-animation.html) 的方式，动态调整节点的 style 属性达到动画的效果
4. 连续使用 setData 来改变界面的方法也可以达到动画的效果，但通常会产生较大的延迟和卡顿

[qa.createAnimation](../../api/ui/animation/qa.createAnimation.html) 使用示例：

```html
<view class="page-section">
  <view class="animation-element-wrapper">
    <view class="animation-element" animation="{{animation}}"></view>
  </view>
  <button class="animation-button" bindtap="rotate">旋转</button>
</view>
```

```JS
Page({
  data: {
    animation: ''
  },
  onReady() {
    this.animation = qa.createAnimation()
  },
  rotate() {
    this.animation.rotate(Math.random() * 720 - 360).step()
    this.setData({ animation: this.animation.export() })
  }
})

```

## 动画事件

可以使用 `bindtransitionend` `bindanimationstart` `bindanimationiteration` `bindanimationend` 监听动画事件。

| 事件名 | 含义 |
| --- | --- |
| transitionend | CSS 渐变结束或 [qa.createAnimation](../../api/ui/animation/qa.createAnimation.html) 结束一个阶段 |
| animationstart | CSS 动画开始 |
| animationiteration | CSS 动画结束一个阶段 |
| animationend | CSS 动画结束 |

注意：这几个事件都不是冒泡事件。
