# 组件生命周期

组件的生命周期，指的是组件自身的一些方法，会在组件生命流程特定的阶段触发。这些方法包括 `created` `attached` `ready` `detached`，具体说明如下：

- `created`: 组件实例刚刚被创建好时， `created` 生命周期被触发。
- `attached`: 在组件完全初始化完毕、进入页面节点树后， `attached` 生命周期被触发。
- `ready`: 在 attached 被触发之后触发
- `detached`: 在组件离开页面节点树后， `detached` 生命周期被触发。退出页面时，如果组件还在页面节点树中， `detached` 也会被触发。

## 定义生命周期方法

生命周期方法可以直接定义在 `Component` 构造器的顶层参数中。也可以在 `lifetimes` 字段内进行声明（推荐写法，其优先级最高，会覆盖顶层参数中的同名方法）。

**代码示例：**

```js
Component({
  lifetimes: {
    attached: function() {
      // ...
    },
    detached: function() {
      // ...
    }
  }
  // ...
})
```

在 behaviors 中也可以编写生命周期方法，同时不会与其他 behaviors 中的同名生命周期相互覆盖。但要注意，如果一个组件多次直接或间接引用同一个 behavior ，这个 behavior 中的生命周期函数在一个执行时机内只会执行一次。

可用的全部生命周期如下表所示。

| 生命周期 | 参数           | 描述                               | 最低版本 |
| -------- | -------------- | ---------------------------------- | -------- |
| created  | 无             | 在组件实例刚刚被创建时执行         |          |
| attached | 无             | 在组件实例进入页面节点树时执行     |          |
| ready    | 无             | 在组件在渲染层布局完成后执行       |          |
| detached | 无             | 在组件实例被从页面节点树移除时执行 |          |
| error    | `Object Error` | 每当组件方法抛出错误时执行         |          |

## 组件所在页面的生命周期

有时，组件需要获悉所在页面的状态变化，比如显示、隐藏切换，视窗尺寸变化等，这时可以利用 `pageLifetimes` 定义方法监听。这些方法也称为“组件所在页面的生命周期”。其中可用的生命周期包括：

| 生命周期 | 参数          | 描述                         | 最低版本 |
| -------- | ------------- | ---------------------------- | -------- |
| show     | 无            | 组件所在的页面显示时执行     |          |
| hide     | 无            | 组件所在的页面隐藏时执行     |          |
| resize   | `Object Size` | 组件所在的页面尺寸变化时执行 |          |

**代码示例：**

```js
Component({
  pageLifetimes: {
    show: function() {
      // 页面显示时触发
    },
    hide: function() {
      // 页面隐藏时触发
    },
    resize: function(size) {
      // 页面尺寸变化时触发
    }
  }
})
```
