# 组件间通信与事件

## 组件间通信

组件间的基本通信方式:

- 定义子组件 properties：用于父组件向子组件的指定属性设置数据
- 定义事件：用于子组件向父组件传递数据
- 如果以上方式不足以满足需要，父组件还可以通过 `this.selectComponent` 方法获取子组件实例对象，这样就可以直接访问组件的任意数据和方法。

## 监听事件

事件系统是子组件向父组件通信的主要方式。自定义组件可以触发任意的事件，父组件可以监听这些事件。

监听自定义组件事件的方法与监听基础组件事件的方法完全一致：

**代码示例：**

```html
<!-- 当自定义组件触发“customevent”事件时，调用“handleCustomEvent”方法 -->
<custom-component bindcustomevent="handleCustomEvent" />
<!-- 或者用下面写法 -->
<!-- <custom-component bind:customevent="handleCustomEvent" /> -->
```

```js
Page({
  handleCustomEvent: function(e) {
    e.detail // 自定义组件触发事件时提供的detail对象
  }
})
```

## 触发事件

自定义组件使用 `triggerEvent` 触发事件，触发是需要指定事件名和 detail 对象：

**代码示例：**

```html
<!-- 在自定义组件中 -->
<button bindtap="handleTap">点击触发 “customevent” 事件</button>
```

```js
Component({
  properties: {},
  methods: {
    handleTap: function() {
      var customeventDetail = {} // detail对象，提供给事件监听函数
      this.triggerEvent('customevent', customeventDetail)
    }
  }
})
```
