# 页面路由

### 页面栈

快应用框架以栈的形式进行页面管理。当发生路由切换的时候，对应页面栈的表现如下：

| 路由方式   | 页面栈表现                        |
| ---------- | --------------------------------- |
| 初始化     | 新页面入栈                        |
| 打开新页面 | 新页面入栈                        |
| 页面重定向 | 当前页面出栈，新页面入栈          |
| 页面返回   | 页面不断出栈，直到目标返回页      |
| Tab 页切换 | 普通页面全部出栈，只留下 Tab 页面 |

开发者可以通过 `getCurrentPages()` 函数获取当前页面栈，返回结果是页面实例组成的数组。

### 路由和页面生命周期

路由操作会引起页面状态的变化，触发对应的生命周期。不同路由方式导致的生命周期触发情形如下：

| 情形 | 触发方式 | 路由前页面 | 路由后页面 |
| --- | --- | --- | --- |
| 初始化 | 快应用打开的第一个页面 |  | onLoad, onShow |
| 打开新页面 | 调用 API [qa.navigateTo](../../api/route/qa.navigateTo.html) 或使用组件 [`<navigator open-type="navigateTo"/>`](../../component/navigator.html) | onHide | onLoad, onShow |
| 页面重定向 | 调用 API [qa.redirectTo](../../api/route/qa.redirectTo.html) 或使用组件 [`<navigator open-type="redirectTo"/>`](../../component/navigator.html) | onUnload | onLoad, onShow |
| 页面返回 | 调用 API [qa.navigateBack](../../api/route/qa.navigateBack.html) 或使用组件[`<navigator open-type="navigateBack">`](../../component/navigator.html) 或用户按左上角返回按钮 | onUnload | onShow |
| 重新加载 | 调用 API [qa.reLaunch](../../api/route/qa.reLaunch.html) 或使用组件 [`<navigator open-type="reLaunch"/>`](../../component/navigator.html) | onUnload | onLoad, onShow |
| Tab 切换 | 调用 API [qa.switchTab](../../api/route/qa.switchTab.html) 或使用组件 [`<navigator open-type="switchTab"/>`](../../component/navigator.html) 或 用户点击 Tab |  | 具体见下表 |

Tab 切换时，生命周期触发顺序（以 A、B 页面为 tabBar 页面，C 是从 A 页面打开的普通页面，D 页面是从 C 页面打开的普通页面）：

| 当前页面        | 路由后页面    | 触发的生命周期（按顺序）                           |
| --------------- | ------------- | -------------------------------------------------- |
| A               | A             | Nothing happend                                    |
| A               | B             | A.onHide(), B.onLoad(), B.onShow()                 |
| A               | B（再次打开） | A.onHide(), B.onShow()                             |
| C               | A             | C.onUnload(), A.onShow()                           |
| C               | B             | C.onUnload(), B.onLoad(), B.onShow()               |
| D               | B             | D.onUnload(), C.onUnload(), B.onLoad(), B.onShow() |
| D（从转发进入） | A             | D.onUnload(), A.onLoad(), A.onShow()               |
| D（从转发进入） | B             | D.onUnload(), B.onLoad(), B.onShow()               |

**提示**:

- `navigateTo`, `redirectTo` 只能打开非 tabBar 页面。
- `switchTab` 只能打开 tabBar 页面。
- `reLaunch` 可以打开任意页面。
- 页面底部的 tabBar 由配置决定，即只要是定义为 tabBar 的页面，底部都有 tabBar。
- 调用页面路由带的参数可以在目标页面的`onLoad`中获取。
